/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.kew.api.doctype.RouteNodeConfigurationParameter;
import org.kuali.rice.kew.api.doctype.RouteNodeConfigurationParameterContract;
import org.kuali.rice.kew.api.doctype.RouteNodeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="routeNode")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RouteNodeType", propOrder={"id", "documentTypeId", "name", "routeMethodName", "routeMethodCode", "finalApproval", "mandatory", "activationType", "exceptionGroupId", "type", "branchName", "nextDocumentStatus", "configurationParameters", "previousNodeIds", "nextNodeIds", "versionNumber", "_futureElements"})
public final class RouteNode
extends AbstractDataTransferObject
implements RouteNodeContract {
    private static final long serialVersionUID = -1756380702013287285L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="documentTypeId", required=false)
    private final String documentTypeId;
    @XmlElement(name="name", required=true)
    private final String name;
    @XmlElement(name="routeMethodName", required=false)
    private final String routeMethodName;
    @XmlElement(name="routeMethodCode", required=false)
    private final String routeMethodCode;
    @XmlElement(name="finalApproval", required=false)
    private final boolean finalApproval;
    @XmlElement(name="mandatory", required=false)
    private final boolean mandatory;
    @XmlElement(name="activationType", required=false)
    private final String activationType;
    @XmlElement(name="exceptionGroupId", required=false)
    private final String exceptionGroupId;
    @XmlElement(name="type", required=true)
    private final String type;
    @XmlElement(name="branchName", required=false)
    private final String branchName;
    @XmlElement(name="nextDocumentStatus", required=false)
    private final String nextDocumentStatus;
    @XmlElementWrapper(name="configurationParameters", required=false)
    @XmlElement(name="configurationParameter", required=false)
    private final List<RouteNodeConfigurationParameter> configurationParameters;
    @XmlElementWrapper(name="previousNodeIds", required=false)
    @XmlElement(name="previousNodeId", required=false)
    private final List<String> previousNodeIds;
    @XmlElementWrapper(name="nextNodeIds", required=false)
    @XmlElement(name="nextNodeId", required=false)
    private final List<String> nextNodeIds;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RouteNode() {
        this.id = null;
        this.documentTypeId = null;
        this.name = null;
        this.routeMethodName = null;
        this.routeMethodCode = null;
        this.finalApproval = false;
        this.mandatory = false;
        this.activationType = null;
        this.exceptionGroupId = null;
        this.type = null;
        this.branchName = null;
        this.nextDocumentStatus = null;
        this.configurationParameters = null;
        this.previousNodeIds = null;
        this.nextNodeIds = null;
        this.versionNumber = null;
    }

    private RouteNode(Builder builder) {
        this.id = builder.getId();
        this.documentTypeId = builder.getDocumentTypeId();
        this.name = builder.getName();
        this.routeMethodName = builder.getRouteMethodName();
        this.routeMethodCode = builder.getRouteMethodCode();
        this.finalApproval = builder.isFinalApproval();
        this.mandatory = builder.isMandatory();
        this.activationType = builder.getActivationType();
        this.exceptionGroupId = builder.getExceptionGroupId();
        this.type = builder.getType();
        this.branchName = builder.getBranchName();
        this.nextDocumentStatus = builder.getNextDocumentStatus();
        this.configurationParameters = new ArrayList<RouteNodeConfigurationParameter>();
        if (builder.getConfigurationParameters() != null) {
            for (RouteNodeConfigurationParameter.Builder configurationParameter : builder.getConfigurationParameters()) {
                this.configurationParameters.add(configurationParameter.build());
            }
        }
        this.previousNodeIds = new ArrayList<String>(builder.getPreviousNodeIds());
        this.nextNodeIds = new ArrayList<String>(builder.getNextNodeIds());
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    @Override
    public String getRouteMethodName() {
        return this.routeMethodName;
    }

    @Override
    public String getRouteMethodCode() {
        return this.routeMethodCode;
    }

    @Override
    public boolean isFinalApproval() {
        return this.finalApproval;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public String getActivationType() {
        return this.activationType;
    }

    @Override
    public String getExceptionGroupId() {
        return this.exceptionGroupId;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getBranchName() {
        return this.branchName;
    }

    @Override
    public String getNextDocumentStatus() {
        return this.nextDocumentStatus;
    }

    public List<RouteNodeConfigurationParameter> getConfigurationParameters() {
        return CollectionUtils.unmodifiableListNullSafe(this.configurationParameters);
    }

    @Override
    public List<String> getPreviousNodeIds() {
        return CollectionUtils.unmodifiableListNullSafe(this.previousNodeIds);
    }

    @Override
    public List<String> getNextNodeIds() {
        return CollectionUtils.unmodifiableListNullSafe(this.nextNodeIds);
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RouteNodeContract {
        private static final long serialVersionUID = 7076065049417371344L;
        private String id;
        private String documentTypeId;
        private String name;
        private String routeMethodName;
        private String routeMethodCode;
        private boolean finalApproval;
        private boolean mandatory;
        private String activationType;
        private String exceptionGroupId;
        private String type;
        private String branchName;
        private String nextDocumentStatus;
        private List<RouteNodeConfigurationParameter.Builder> configurationParameters;
        private List<String> previousNodeIds;
        private List<String> nextNodeIds;
        private Long versionNumber;

        private Builder(String name, String type) {
            this.setName(name);
            this.setType(type);
            this.setConfigurationParameters(new ArrayList<RouteNodeConfigurationParameter.Builder>());
            this.setPreviousNodeIds(new ArrayList<String>());
            this.setNextNodeIds(new ArrayList<String>());
        }

        public static Builder create(String name, String type) {
            return new Builder(name, type);
        }

        public static Builder create(RouteNodeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getName(), contract.getType());
            builder.setId(contract.getId());
            builder.setDocumentTypeId(contract.getDocumentTypeId());
            builder.setName(contract.getName());
            builder.setRouteMethodName(contract.getRouteMethodName());
            builder.setRouteMethodCode(contract.getRouteMethodCode());
            builder.setFinalApproval(contract.isFinalApproval());
            builder.setMandatory(contract.isMandatory());
            builder.setActivationType(contract.getActivationType());
            builder.setExceptionGroupId(contract.getExceptionGroupId());
            builder.setType(contract.getType());
            builder.setBranchName(contract.getBranchName());
            builder.setNextDocumentStatus(contract.getNextDocumentStatus());
            ArrayList<RouteNodeConfigurationParameter.Builder> parameterBuilders = new ArrayList<RouteNodeConfigurationParameter.Builder>();
            for (RouteNodeConfigurationParameterContract routeNodeConfigurationParameterContract : contract.getConfigurationParameters()) {
                parameterBuilders.add(RouteNodeConfigurationParameter.Builder.create(routeNodeConfigurationParameterContract));
            }
            builder.setConfigurationParameters(parameterBuilders);
            builder.setPreviousNodeIds(contract.getPreviousNodeIds());
            builder.setNextNodeIds(contract.getNextNodeIds());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public RouteNode build() {
            return new RouteNode(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getDocumentTypeId() {
            return this.documentTypeId;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getRouteMethodName() {
            return this.routeMethodName;
        }

        @Override
        public String getRouteMethodCode() {
            return this.routeMethodCode;
        }

        @Override
        public boolean isFinalApproval() {
            return this.finalApproval;
        }

        @Override
        public boolean isMandatory() {
            return this.mandatory;
        }

        @Override
        public String getActivationType() {
            return this.activationType;
        }

        @Override
        public String getExceptionGroupId() {
            return this.exceptionGroupId;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public String getBranchName() {
            return this.branchName;
        }

        @Override
        public String getNextDocumentStatus() {
            return this.nextDocumentStatus;
        }

        public List<RouteNodeConfigurationParameter.Builder> getConfigurationParameters() {
            return this.configurationParameters;
        }

        @Override
        public List<String> getPreviousNodeIds() {
            return this.previousNodeIds;
        }

        @Override
        public List<String> getNextNodeIds() {
            return this.nextNodeIds;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setDocumentTypeId(String documentTypeId) {
            this.documentTypeId = documentTypeId;
        }

        public void setName(String name) {
            if (StringUtils.isBlank((String)name)) {
                throw new IllegalArgumentException("name was null or blank");
            }
            this.name = name;
        }

        public void setRouteMethodName(String routeMethodName) {
            this.routeMethodName = routeMethodName;
        }

        public void setRouteMethodCode(String routeMethodCode) {
            this.routeMethodCode = routeMethodCode;
        }

        public void setFinalApproval(boolean finalApproval) {
            this.finalApproval = finalApproval;
        }

        public void setMandatory(boolean mandatory) {
            this.mandatory = mandatory;
        }

        public void setActivationType(String activationType) {
            this.activationType = activationType;
        }

        public void setExceptionGroupId(String exceptionGroupId) {
            this.exceptionGroupId = exceptionGroupId;
        }

        public void setType(String type) {
            if (StringUtils.isBlank((String)type)) {
                throw new IllegalArgumentException("type was null or blank");
            }
            this.type = type;
        }

        public void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public void setNextDocumentStatus(String nextDocumentStatus) {
            this.nextDocumentStatus = nextDocumentStatus;
        }

        public void setConfigurationParameters(List<RouteNodeConfigurationParameter.Builder> configurationParameters) {
            if (configurationParameters == null) {
                throw new IllegalArgumentException("configurationParameters was null");
            }
            this.configurationParameters = configurationParameters;
        }

        public void setPreviousNodeIds(List<String> previousNodeIds) {
            if (previousNodeIds == null) {
                throw new IllegalArgumentException("previousNodeIds was null");
            }
            this.previousNodeIds = previousNodeIds;
        }

        public void setNextNodeIds(List<String> nextNodeIds) {
            if (nextNodeIds == null) {
                throw new IllegalArgumentException("nextNodeIds was null");
            }
            this.nextNodeIds = nextNodeIds;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String DOCUMENT_TYPE_ID = "documentTypeId";
        static final String NAME = "name";
        static final String ROUTE_METHOD_NAME = "routeMethodName";
        static final String ROUTE_METHOD_CODE = "routeMethodCode";
        static final String FINAL_APPROVAL = "finalApproval";
        static final String MANDATORY = "mandatory";
        static final String ACTIVATION_TYPE = "activationType";
        static final String EXCEPTION_GROUP_ID = "exceptionGroupId";
        static final String TYPE = "type";
        static final String BRANCH_NAME = "branchName";
        static final String NEXT_DOCUMENT_STATUS = "nextDocumentStatus";
        static final String CONFIGURATION_PARAMETERS = "configurationParameters";
        static final String CONFIGURATION_PARAMETER = "configurationParameter";
        static final String PREVIOUS_NODE_IDS = "previousNodeIds";
        static final String PREVIOUS_NODE_ID = "previousNodeId";
        static final String NEXT_NODE_IDS = "nextNodeIds";
        static final String NEXT_NODE_ID = "nextNodeId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "routeNode";
        static final String TYPE_NAME = "RouteNodeType";

        Constants() {
        }
    }
}

