/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kew.api.document.DocumentContract;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.w3c.dom.Element;

@XmlRootElement(name="document")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentType", propOrder={"documentId", "status", "dateCreated", "dateLastModified", "dateApproved", "dateFinalized", "title", "applicationDocumentId", "initiatorPrincipalId", "routedByPrincipalId", "documentTypeName", "documentTypeId", "documentHandlerUrl", "applicationDocumentStatus", "applicationDocumentStatusDate", "variables", "_futureElements"})
public final class Document
extends AbstractDataTransferObject
implements DocumentContract {
    private static final long serialVersionUID = -6954090887747605047L;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="status", required=true)
    private final String status;
    @XmlElement(name="dateCreated", required=true)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateCreated;
    @XmlElement(name="dateLastModified", required=true)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateLastModified;
    @XmlElement(name="dateApproved", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateApproved;
    @XmlElement(name="dateFinalized", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateFinalized;
    @XmlElement(name="title", required=false)
    private final String title;
    @XmlElement(name="applicationDocumentId", required=false)
    private final String applicationDocumentId;
    @XmlElement(name="initiatorPrincipalId", required=true)
    private final String initiatorPrincipalId;
    @XmlElement(name="routedByPrincipalId", required=false)
    private final String routedByPrincipalId;
    @XmlElement(name="documentTypeName", required=true)
    private final String documentTypeName;
    @XmlElement(name="documentTypeId", required=true)
    private final String documentTypeId;
    @XmlElement(name="documentHandlerUrl", required=false)
    private final String documentHandlerUrl;
    @XmlElement(name="applicationDocumentStatus", required=false)
    private final String applicationDocumentStatus;
    @XmlElement(name="applicationDocumentStatusDate", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime applicationDocumentStatusDate;
    @XmlElement(name="variables", required=false)
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    private final Map<String, String> variables;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Document() {
        this.documentId = null;
        this.status = null;
        this.dateCreated = null;
        this.dateLastModified = null;
        this.dateApproved = null;
        this.dateFinalized = null;
        this.title = null;
        this.applicationDocumentId = null;
        this.initiatorPrincipalId = null;
        this.routedByPrincipalId = null;
        this.documentTypeName = null;
        this.documentTypeId = null;
        this.documentHandlerUrl = null;
        this.applicationDocumentStatus = null;
        this.applicationDocumentStatusDate = null;
        this.variables = null;
    }

    private Document(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.status = builder.getStatus().getCode();
        this.dateCreated = builder.getDateCreated();
        this.dateLastModified = builder.getDateLastModified();
        this.dateApproved = builder.getDateApproved();
        this.dateFinalized = builder.getDateFinalized();
        this.title = builder.getTitle();
        this.applicationDocumentId = builder.getApplicationDocumentId();
        this.initiatorPrincipalId = builder.getInitiatorPrincipalId();
        this.routedByPrincipalId = builder.getRoutedByPrincipalId();
        this.documentTypeName = builder.getDocumentTypeName();
        this.documentTypeId = builder.getDocumentTypeId();
        this.documentHandlerUrl = builder.getDocumentHandlerUrl();
        this.applicationDocumentStatus = builder.getApplicationDocumentStatus();
        this.applicationDocumentStatusDate = builder.getApplicationDocumentStatusDate();
        this.variables = new HashMap<String, String>(builder.getVariables());
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public DocumentStatus getStatus() {
        if (StringUtils.isBlank((String)this.status)) {
            throw new IllegalStateException("Status should not be null");
        }
        return DocumentStatus.fromCode(this.status);
    }

    @Override
    public DateTime getDateCreated() {
        return this.dateCreated;
    }

    @Override
    public DateTime getDateLastModified() {
        return this.dateLastModified;
    }

    @Override
    public DateTime getDateApproved() {
        return this.dateApproved;
    }

    @Override
    public DateTime getDateFinalized() {
        return this.dateFinalized;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getApplicationDocumentId() {
        return this.applicationDocumentId;
    }

    @Override
    public String getInitiatorPrincipalId() {
        return this.initiatorPrincipalId;
    }

    @Override
    public String getRoutedByPrincipalId() {
        return this.routedByPrincipalId;
    }

    @Override
    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    @Override
    public String getDocumentTypeId() {
        return this.documentTypeId;
    }

    @Override
    public String getDocumentHandlerUrl() {
        return this.documentHandlerUrl;
    }

    @Override
    public String getApplicationDocumentStatus() {
        return this.applicationDocumentStatus;
    }

    @Override
    public DateTime getApplicationDocumentStatusDate() {
        return this.applicationDocumentStatusDate;
    }

    @Override
    public Map<String, String> getVariables() {
        return Collections.unmodifiableMap(this.variables);
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentContract {
        private static final long serialVersionUID = -1584497024880308500L;
        private String documentId;
        private DocumentStatus status;
        private DateTime dateCreated;
        private DateTime dateLastModified;
        private DateTime dateApproved;
        private DateTime dateFinalized;
        private String title;
        private String applicationDocumentId;
        private String initiatorPrincipalId;
        private String routedByPrincipalId;
        private String documentTypeName;
        private String documentTypeId;
        private String documentHandlerUrl;
        private String applicationDocumentStatus;
        private DateTime applicationDocumentStatusDate;
        private Map<String, String> variables;

        private Builder(String documentId, DocumentStatus status, DateTime dateCreated, String initiatorPrincipalId, String documentTypeName, String documentTypeId) {
            this.setDocumentId(documentId);
            this.setStatus(status);
            this.setDateCreated(dateCreated);
            this.setTitle("");
            this.setInitiatorPrincipalId(initiatorPrincipalId);
            this.setDocumentTypeName(documentTypeName);
            this.setDocumentTypeId(documentTypeId);
            this.setVariables(new HashMap<String, String>());
        }

        public static Builder create(String documentId, DocumentStatus status, DateTime dateCreated, String initiatorPrincipalId, String documentTypeName, String documentTypeId) {
            return new Builder(documentId, status, dateCreated, initiatorPrincipalId, documentTypeName, documentTypeId);
        }

        public static Builder create(String documentId, String initiatorPrinicpalId, String documentTypeName, String documentTypeId) {
            return new Builder(documentId, DocumentStatus.INITIATED, new DateTime(), initiatorPrinicpalId, documentTypeName, documentTypeId);
        }

        public static Builder create(DocumentContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getDocumentId(), contract.getStatus(), contract.getDateCreated(), contract.getInitiatorPrincipalId(), contract.getDocumentTypeName(), contract.getDocumentTypeId());
            builder.setDateLastModified(contract.getDateLastModified());
            builder.setDateApproved(contract.getDateApproved());
            builder.setDateFinalized(contract.getDateFinalized());
            builder.setTitle(contract.getTitle());
            builder.setApplicationDocumentId(contract.getApplicationDocumentId());
            builder.setRoutedByPrincipalId(contract.getRoutedByPrincipalId());
            builder.setDocumentHandlerUrl(contract.getDocumentHandlerUrl());
            builder.setApplicationDocumentStatus(contract.getApplicationDocumentStatus());
            builder.setApplicationDocumentStatusDate(contract.getApplicationDocumentStatusDate());
            builder.setVariables(new HashMap<String, String>(contract.getVariables()));
            return builder;
        }

        public Document build() {
            return new Document(this);
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public DocumentStatus getStatus() {
            return this.status;
        }

        @Override
        public DateTime getDateCreated() {
            return this.dateCreated;
        }

        @Override
        public DateTime getDateLastModified() {
            return this.dateLastModified;
        }

        @Override
        public DateTime getDateApproved() {
            return this.dateApproved;
        }

        @Override
        public DateTime getDateFinalized() {
            return this.dateFinalized;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getApplicationDocumentId() {
            return this.applicationDocumentId;
        }

        @Override
        public String getInitiatorPrincipalId() {
            return this.initiatorPrincipalId;
        }

        @Override
        public String getRoutedByPrincipalId() {
            return this.routedByPrincipalId;
        }

        @Override
        public String getDocumentTypeName() {
            return this.documentTypeName;
        }

        @Override
        public String getDocumentTypeId() {
            return this.documentTypeId;
        }

        @Override
        public String getDocumentHandlerUrl() {
            return this.documentHandlerUrl;
        }

        @Override
        public String getApplicationDocumentStatus() {
            return this.applicationDocumentStatus;
        }

        @Override
        public DateTime getApplicationDocumentStatusDate() {
            return this.applicationDocumentStatusDate;
        }

        @Override
        public Map<String, String> getVariables() {
            return this.variables;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setStatus(DocumentStatus status) {
            if (status == null) {
                throw new IllegalArgumentException("status was null");
            }
            this.status = status;
        }

        public void setDateCreated(DateTime dateCreated) {
            if (dateCreated == null) {
                throw new IllegalArgumentException("dateCreated was null");
            }
            this.dateCreated = dateCreated;
        }

        public void setDateLastModified(DateTime dateLastModified) {
            this.dateLastModified = dateLastModified;
        }

        public void setDateApproved(DateTime dateApproved) {
            this.dateApproved = dateApproved;
        }

        public void setDateFinalized(DateTime dateFinalized) {
            this.dateFinalized = dateFinalized;
        }

        public void setTitle(String title) {
            if (title == null) {
                title = "";
            }
            this.title = title;
        }

        public void setApplicationDocumentId(String applicationDocumentId) {
            this.applicationDocumentId = applicationDocumentId;
        }

        public void setInitiatorPrincipalId(String initiatorPrincipalId) {
            if (StringUtils.isBlank((String)initiatorPrincipalId)) {
                throw new IllegalArgumentException("initiatorPrincipalId was null or blank");
            }
            this.initiatorPrincipalId = initiatorPrincipalId;
        }

        public void setRoutedByPrincipalId(String routedByPrincipalId) {
            this.routedByPrincipalId = routedByPrincipalId;
        }

        public void setDocumentTypeName(String documentTypeName) {
            if (StringUtils.isBlank((String)documentTypeName)) {
                throw new IllegalArgumentException("documentTypeName was null or blank");
            }
            this.documentTypeName = documentTypeName;
        }

        public void setDocumentTypeId(String documentTypeId) {
            if (StringUtils.isBlank((String)documentTypeId)) {
                throw new IllegalArgumentException("documentTypeId was null or blank");
            }
            this.documentTypeId = documentTypeId;
        }

        public void setDocumentHandlerUrl(String documentHandlerUrl) {
            this.documentHandlerUrl = documentHandlerUrl;
        }

        public void setApplicationDocumentStatus(String applicationDocumentStatus) {
            this.applicationDocumentStatus = applicationDocumentStatus;
        }

        public void setApplicationDocumentStatusDate(DateTime applicationDocumentStatusDate) {
            this.applicationDocumentStatusDate = applicationDocumentStatusDate;
        }

        public void setVariables(Map<String, String> variables) {
            if (variables == null) {
                variables = new HashMap<String, String>();
            }
            this.variables = variables;
        }
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String STATUS = "status";
        static final String DATE_CREATED = "dateCreated";
        static final String DATE_LAST_MODIFIED = "dateLastModified";
        static final String DATE_APPROVED = "dateApproved";
        static final String DATE_FINALIZED = "dateFinalized";
        static final String TITLE = "title";
        static final String APPLICATION_DOCUMENT_ID = "applicationDocumentId";
        static final String INITIATOR_PRINCIPAL_ID = "initiatorPrincipalId";
        static final String ROUTED_BY_PRINCIPAL_ID = "routedByPrincipalId";
        static final String DOCUMENT_TYPE_NAME = "documentTypeName";
        static final String DOCUMENT_TYPE_ID = "documentTypeId";
        static final String DOCUMENT_HANDLER_URL = "documentHandlerUrl";
        static final String APPLICATION_DOCUMENT_STATUS = "applicationDocumentStatus";
        static final String APPLICATION_DOCUMENT_STATUS_DATE = "applicationDocumentStatusDate";
        static final String VARIABLES = "variables";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "document";
        static final String TYPE_NAME = "DocumentType";

        Constants() {
        }
    }
}

