/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.document.DocumentLinkContract;
import org.w3c.dom.Element;

@XmlRootElement(name="documentLink")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentLinkType", propOrder={"id", "originatingDocumentId", "destinationDocumentId", "_futureElements"})
public final class DocumentLink
extends AbstractDataTransferObject
implements DocumentLinkContract {
    private static final long serialVersionUID = -1193048221115914280L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="originatingDocumentId", required=true)
    private final String originatingDocumentId;
    @XmlElement(name="destinationDocumentId", required=true)
    private final String destinationDocumentId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentLink() {
        this.id = null;
        this.originatingDocumentId = null;
        this.destinationDocumentId = null;
    }

    private DocumentLink(Builder builder) {
        this.id = builder.getId();
        this.originatingDocumentId = builder.getOriginatingDocumentId();
        this.destinationDocumentId = builder.getDestinationDocumentId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getOriginatingDocumentId() {
        return this.originatingDocumentId;
    }

    @Override
    public String getDestinationDocumentId() {
        return this.destinationDocumentId;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentLinkContract {
        private static final long serialVersionUID = -6713990840543140054L;
        private String id;
        private String originatingDocumentId;
        private String destinationDocumentId;

        private Builder(String originatingDocumentId, String destinationDocumentId) {
            this.setOriginatingDocumentId(originatingDocumentId);
            this.setDestinationDocumentId(destinationDocumentId);
            if (this.getOriginatingDocumentId().equals(this.getDestinationDocumentId())) {
                throw new IllegalArgumentException("originating and destination document ids were the same, cannot link a document with itself");
            }
        }

        public static Builder create(String originatingDocumentId, String destinationDocumentId) {
            return new Builder(originatingDocumentId, destinationDocumentId);
        }

        public static Builder create(DocumentLinkContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getOriginatingDocumentId(), contract.getDestinationDocumentId());
            builder.setId(contract.getId());
            return builder;
        }

        public DocumentLink build() {
            return new DocumentLink(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getOriginatingDocumentId() {
            return this.originatingDocumentId;
        }

        @Override
        public String getDestinationDocumentId() {
            return this.destinationDocumentId;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setOriginatingDocumentId(String originatingDocumentId) {
            if (StringUtils.isBlank((String)originatingDocumentId)) {
                throw new IllegalArgumentException("originatingDocumentId was null or blank");
            }
            this.originatingDocumentId = originatingDocumentId;
        }

        public void setDestinationDocumentId(String destinationDocumentId) {
            if (StringUtils.isBlank((String)destinationDocumentId)) {
                throw new IllegalArgumentException("destinationDocumentId was null or blank");
            }
            this.destinationDocumentId = destinationDocumentId;
        }
    }

    static class Elements {
        static final String ID = "id";
        static final String ORIGINATING_DOCUMENT_ID = "originatingDocumentId";
        static final String DESTINATION_DOCUMENT_ID = "destinationDocumentId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentLink";
        static final String TYPE_NAME = "DocumentLinkType";

        Constants() {
        }
    }
}

