/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.rule;

import org.kuali.rice.core.api.util.KeyValue;

import java.util.List;
import java.util.Map;

public interface RuleReportCriteriaContract {
    String getRuleDescription();
    String getDocumentTypeName();
    String getRuleTemplateName();
    List<String> getActionRequestCodes();
    String getResponsiblePrincipalId();
    String getResponsibleGroupId();
    String getResponsibleRoleName();
    Map<String, String> getRuleExtensions();
    boolean isActive();
    boolean isConsiderGroupMembership();
    boolean isIncludeDelegations();
}
