/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.document.node;

import java.util.List;

import org.kuali.rice.core.api.mo.common.Identifiable;

public interface RouteNodeInstanceContract extends Identifiable {

	String getDocumentId();

	String getBranchId();
	
	String getRouteNodeId();
	
	String getProcessId();
	
	String getName();
	
	boolean isActive();
	
	boolean isComplete();
	
	boolean isInitial();
	
	List<? extends RouteNodeInstanceStateContract> getState();

    List<? extends RouteNodeInstanceContract> getNextNodeInstances();
	
}
