/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.doctype;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.collect.CollectionUtils;
import org.kuali.rice.kew.api.doctype.ProcessDefinition;
import org.kuali.rice.kew.api.doctype.ProcessDefinitionContract;
import org.kuali.rice.kew.api.doctype.RoutePathContract;
import org.w3c.dom.Element;

@XmlRootElement(name="routePath")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RoutePathType", propOrder={"processDefinitions", "_futureElements"})
public final class RoutePath
extends AbstractDataTransferObject
implements RoutePathContract {
    private static final long serialVersionUID = -7177305375323986864L;
    @XmlElementWrapper(name="processDefinitions", required=false)
    @XmlElement(name="processDefinition", required=false)
    private final List<ProcessDefinition> processDefinitions;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private RoutePath() {
        this.processDefinitions = null;
    }

    private RoutePath(Builder builder) {
        this.processDefinitions = new ArrayList<ProcessDefinition>();
        if (builder.getProcessDefinitions() != null) {
            for (ProcessDefinition.Builder processBuilder : builder.getProcessDefinitions()) {
                this.processDefinitions.add(processBuilder.build());
            }
        }
    }

    public ProcessDefinition getPrimaryProcess() {
        for (ProcessDefinition processDefinition : this.processDefinitions) {
            if (!processDefinition.isInitial()) continue;
            return processDefinition;
        }
        return null;
    }

    public List<ProcessDefinition> getProcessDefinitions() {
        return CollectionUtils.unmodifiableListNullSafe(this.processDefinitions);
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RoutePathContract {
        private static final long serialVersionUID = -6916424305298043710L;
        private List<ProcessDefinition.Builder> processes;

        private Builder() {
        }

        public static Builder create() {
            Builder builder = new Builder();
            builder.setProcesses(new ArrayList<ProcessDefinition.Builder>());
            return builder;
        }

        public static Builder create(RoutePathContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            ArrayList<ProcessDefinition.Builder> processBuilders = new ArrayList<ProcessDefinition.Builder>();
            for (ProcessDefinitionContract processDefinitionContract : contract.getProcessDefinitions()) {
                processBuilders.add(ProcessDefinition.Builder.create(processDefinitionContract));
            }
            builder.setProcesses(processBuilders);
            return builder;
        }

        public RoutePath build() {
            return new RoutePath(this);
        }

        public List<ProcessDefinition.Builder> getProcessDefinitions() {
            return this.processes;
        }

        public void setProcesses(List<ProcessDefinition.Builder> processes) {
            this.processes = processes;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/RoutePathType";
    }

    static class Elements {
        static final String PROCESSES = "processDefinitions";
        static final String PROCESS = "processDefinition";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "routePath";
        static final String TYPE_NAME = "RoutePathType";

        Constants() {
        }
    }
}

