/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.note;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kew.api.note.NoteContract;
import org.w3c.dom.Element;

@XmlRootElement(name="note")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="NoteType", propOrder={"id", "documentId", "authorPrincipalId", "createDate", "text", "createDateValue", "versionNumber", "_futureElements"})
public final class Note
extends AbstractDataTransferObject
implements NoteContract {
    private static final long serialVersionUID = 6619061362854480922L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="documentId", required=true)
    private final String documentId;
    @XmlElement(name="authorPrincipalId", required=true)
    private final String authorPrincipalId;
    @Deprecated
    @XmlElement(name="createDate", required=false)
    private final DateTime createDate;
    @XmlElement(name="createDateValue", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime createDateValue;
    @XmlElement(name="text", required=false)
    private final String text;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Note() {
        this.id = null;
        this.documentId = null;
        this.authorPrincipalId = null;
        this.createDate = null;
        this.createDateValue = null;
        this.text = null;
        this.versionNumber = null;
    }

    private Note(Builder builder) {
        this.id = builder.getId();
        this.documentId = builder.getDocumentId();
        this.authorPrincipalId = builder.getAuthorPrincipalId();
        this.createDate = builder.getCreateDate();
        this.createDateValue = builder.getCreateDate();
        this.text = builder.getText();
        this.versionNumber = builder.getVersionNumber();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public String getAuthorPrincipalId() {
        return this.authorPrincipalId;
    }

    @Override
    public DateTime getCreateDate() {
        return this.createDateValue == null ? this.createDate : this.createDateValue;
    }

    @Override
    public String getText() {
        return this.text;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    NoteContract {
        private static final long serialVersionUID = 6457130539374835936L;
        private String id;
        private String documentId;
        private String authorPrincipalId;
        private DateTime createDate;
        private String text;
        private Long versionNumber;

        private Builder(String documentId, String authorPrincipalId) {
            this.setDocumentId(documentId);
            this.setAuthorPrincipalId(authorPrincipalId);
        }

        public static Builder create(String documentId, String authorPrincipalId) {
            return new Builder(documentId, authorPrincipalId);
        }

        public static Builder create(NoteContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getDocumentId(), contract.getAuthorPrincipalId());
            builder.setId(contract.getId());
            builder.setCreateDate(contract.getCreateDate());
            builder.setText(contract.getText());
            builder.setVersionNumber(contract.getVersionNumber());
            return builder;
        }

        public Note build() {
            return new Note(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public String getAuthorPrincipalId() {
            return this.authorPrincipalId;
        }

        @Override
        public DateTime getCreateDate() {
            return this.createDate;
        }

        @Override
        public String getText() {
            return this.text;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setDocumentId(String documentId) {
            if (StringUtils.isBlank((String)documentId)) {
                throw new IllegalArgumentException("documentId was null or blank");
            }
            this.documentId = documentId;
        }

        public void setAuthorPrincipalId(String authorPrincipalId) {
            if (StringUtils.isBlank((String)authorPrincipalId)) {
                throw new IllegalArgumentException("authorPrincipalId was null or blank");
            }
            this.authorPrincipalId = authorPrincipalId;
        }

        public void setCreateDate(DateTime createDate) {
            this.createDate = createDate;
        }

        public void setText(String text) {
            this.text = text;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String AUTHOR_PRINCIPAL_ID = "authorPrincipalId";
        static final String CREATE_DATE = "createDate";
        static final String CREATE_DATE_VALUE = "createDateValue";
        static final String TEXT = "text";
        static final String ID = "id";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "note";
        static final String TYPE_NAME = "NoteType";

        Constants() {
        }
    }
}

