/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.repository.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kew.api.repository.type.KewAttributeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeAttributeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="KewTypeAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KewTypeAttributeType", propOrder={"id", "typeId", "attributeDefinitionId", "sequenceNumber", "active", "attributeDefinition", "_futureElements"})
public final class KewTypeAttribute
extends AbstractDataTransferObject
implements KewTypeAttributeContract {
    private static final long serialVersionUID = -304265575559412478L;
    @XmlElement(name="id", required=true)
    private String id;
    @XmlElement(name="typeId", required=true)
    private String typeId;
    @XmlElement(name="attributeDefinitionId", required=true)
    private String attributeDefinitionId;
    @XmlElement(name="sequenceNumber", required=true)
    private Integer sequenceNumber;
    @XmlElement(name="active", required=false)
    private boolean active;
    @XmlElement(name="attributeDefinition", required=false)
    private KewAttributeDefinition attributeDefinition;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KewTypeAttribute() {
        this.id = null;
        this.typeId = null;
        this.attributeDefinitionId = null;
        this.sequenceNumber = null;
        this.active = false;
        this.attributeDefinition = null;
    }

    private KewTypeAttribute(Builder builder) {
        this.id = builder.getId();
        this.typeId = builder.getTypeId();
        this.attributeDefinitionId = builder.getAttributeDefinitionId();
        this.sequenceNumber = builder.getSequenceNumber();
        this.active = builder.isActive();
        if (builder.getAttributeDefinition() != null) {
            this.attributeDefinition = builder.getAttributeDefinition().build();
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getTypeId() {
        return this.typeId;
    }

    @Override
    public String getAttributeDefinitionId() {
        return this.attributeDefinitionId;
    }

    @Override
    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public KewAttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public static class Builder
    implements KewTypeAttributeContract,
    ModelBuilder,
    Serializable {
        private static final long serialVersionUID = 2729964674427296346L;
        private String id;
        private String typeId;
        private String attributeDefinitionId;
        private Integer sequenceNumber;
        private boolean active;
        private KewAttributeDefinition.Builder attributeDefinition;

        private Builder(String id, String typeId, String attributeDefinitionId, Integer sequenceNumber) {
            this.setId(id);
            this.setTypeId(typeId);
            this.setAttributeDefinitionId(attributeDefinitionId);
            this.setSequenceNumber(sequenceNumber);
            this.setActive(true);
        }

        public Builder attributeDefinition(KewAttributeDefinition.Builder attributeDefinition) {
            this.setAttributeDefinition(attributeDefinition);
            return this;
        }

        public static Builder create(String id, String typeId, String attributeDefinitionId, Integer sequenceNumber) {
            return new Builder(id, typeId, attributeDefinitionId, sequenceNumber);
        }

        public static Builder create(KewTypeAttributeContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract is null");
            }
            Builder builder = new Builder(contract.getId(), contract.getTypeId(), contract.getAttributeDefinitionId(), contract.getSequenceNumber());
            if (contract.getAttributeDefinition() != null) {
                KewAttributeDefinition.Builder attrBuilder = KewAttributeDefinition.Builder.create(contract.getAttributeDefinition());
                builder.setAttributeDefinition(attrBuilder);
            }
            return builder;
        }

        public void setId(String id) {
            if (null != id && StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id must be null or non-blank");
            }
            this.id = id;
        }

        public void setTypeId(String typeId) {
            if (null != typeId && StringUtils.isBlank((String)typeId)) {
                throw new IllegalArgumentException("typeId must be null or non-blank");
            }
            this.typeId = typeId;
        }

        public void setAttributeDefinitionId(String attributeDefinitionId) {
            if (StringUtils.isBlank((String)attributeDefinitionId)) {
                throw new IllegalArgumentException("the attribute definition id is blank");
            }
            this.attributeDefinitionId = attributeDefinitionId;
        }

        public void setSequenceNumber(Integer sequenceNumber) {
            if (sequenceNumber == null) {
                throw new IllegalArgumentException("the sequence number is null");
            }
            this.sequenceNumber = sequenceNumber;
        }

        public void setAttributeDefinition(KewAttributeDefinition.Builder attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getTypeId() {
            return this.typeId;
        }

        @Override
        public String getAttributeDefinitionId() {
            return this.attributeDefinitionId;
        }

        @Override
        public Integer getSequenceNumber() {
            return this.sequenceNumber;
        }

        @Override
        public KewAttributeDefinition.Builder getAttributeDefinition() {
            return this.attributeDefinition;
        }

        public boolean isActive() {
            return this.active;
        }

        public KewTypeAttribute build() {
            return new KewTypeAttribute(this);
        }
    }

    public static class Elements {
        static final String ID = "id";
        static final String TYPE_ID = "typeId";
        static final String ATTR_DEFN_ID = "attributeDefinitionId";
        static final String SEQ_NO = "sequenceNumber";
        static final String ACTIVE = "active";
        static final String ATTR_DEFN = "attributeDefinition";
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "KewTypeAttribute";
        static final String TYPE_NAME = "KewTypeAttributeType";

        Constants() {
        }
    }
}

