/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import org.joda.time.DateTime;
import org.kuali.rice.core.api.delegation.DelegationType;

public interface ActionItemContract {
    String getId();
    DateTime getDateTimeAssigned();
    String getActionRequestCd();
    String getActionRequestId();
    String getDocumentId();
    String getDocTitle();
    String getDocLabel();
    String getDocHandlerURL();
    String getDocName();
    String getResponsibilityId();
    String getRoleName();
    DelegationType getDelegationType();
    String getGroupId();
    String getPrincipalId();
    String getDelegatorGroupId();
    String getDelegatorPrincipalId();

    /**
     * This method should never be called, has been deprecated, and will always return null. It was mistakenly added to
     * this interface when it was created and has been left here for compatibility purposes.
     *
     * @return always returns null
     * @deprecated dateAssignedString is never used
     */
    @Deprecated
    String getDateAssignedString();

    /**
     * This method should never be called, has been deprecated, and will always return null. It was mistakenly added to
     * this interface when it was created and has been left here for compatibility purposes.
     *
     * @return always returns null
     * @deprecated actionToTake is never used
     */
    @Deprecated
    String getActionToTake();

    /**
     * This method should never be called, has been deprecated, and will always return null. It was mistakenly added to
     * this interface when it was created and has been left here for compatibility purposes.
     *
     * @return always returns null
     * @deprecated actionItemIndex is never used
     */
    @Deprecated
    Integer getActionItemIndex();


}
