/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.extension;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.reflect.ObjectDefinition;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.extension.ExtensionDefinitionContract;

public final class ExtensionUtils {
    public static <T> T loadExtension(ExtensionDefinitionContract extensionDefinition) {
        return ExtensionUtils.loadExtension(extensionDefinition, null);
    }

    public static <T> T loadExtension(ExtensionDefinitionContract extensionDefinition, String defaultApplicationId) {
        Object extensionService = null;
        String resourceDescriptor = extensionDefinition.getResourceDescriptor();
        ObjectDefinition extensionObjectDefinition = ExtensionUtils.getExtensionObjectDefinition(extensionDefinition, defaultApplicationId);
        extensionService = GlobalResourceLoader.getObject((ObjectDefinition)extensionObjectDefinition);
        if (extensionService == null) {
            extensionService = GlobalResourceLoader.getService((QName)QName.valueOf(resourceDescriptor));
        }
        return (T)extensionService;
    }

    private static ObjectDefinition getExtensionObjectDefinition(ExtensionDefinitionContract extensionDefinition, String defaultApplicationId) {
        if (StringUtils.isBlank((String)extensionDefinition.getApplicationId()) && StringUtils.isNotBlank((String)defaultApplicationId)) {
            return new ObjectDefinition(extensionDefinition.getResourceDescriptor(), defaultApplicationId);
        }
        return new ObjectDefinition(extensionDefinition.getResourceDescriptor(), extensionDefinition.getApplicationId());
    }

    private ExtensionUtils() {
        throw new UnsupportedOperationException();
    }
}

