/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.kew.api.rule.RuleContract;
import org.kuali.rice.kew.api.rule.RuleExpression;
import org.kuali.rice.kew.api.rule.RuleExtension;
import org.kuali.rice.kew.api.rule.RuleExtensionContract;
import org.kuali.rice.kew.api.rule.RuleResponsibility;
import org.kuali.rice.kew.api.rule.RuleResponsibilityContract;
import org.kuali.rice.kew.api.rule.RuleTemplate;
import org.w3c.dom.Element;

@XmlRootElement(name="rule")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="RuleType", propOrder={"id", "name", "ruleTemplate", "active", "description", "docTypeName", "fromDate", "toDate", "forceAction", "previousRuleId", "ruleResponsibilities", "ruleExtensions", "ruleTemplateName", "ruleExpressionDef", "fromDateValue", "toDateValue", "_futureElements"})
public final class Rule
extends AbstractDataTransferObject
implements RuleContract {
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="name", required=false)
    private final String name;
    @XmlElement(name="ruleTemplate", required=false)
    private final RuleTemplate ruleTemplate;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="description", required=false)
    private final String description;
    @XmlElement(name="docTypeName", required=false)
    private final String docTypeName;
    @Deprecated
    @XmlElement(name="fromDate", required=false)
    private final DateTime fromDate;
    @Deprecated
    @XmlElement(name="toDate", required=false)
    private final DateTime toDate;
    @XmlElement(name="fromDateValue", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime fromDateValue;
    @XmlElement(name="toDateValue", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime toDateValue;
    @XmlElement(name="forceAction", required=false)
    private final boolean forceAction;
    @XmlElement(name="previousRuleId", required=false)
    private final String previousRuleId;
    @XmlElementWrapper(name="ruleResponsibilities", required=false)
    @XmlElement(name="ruleResponsibility", required=false)
    private final List<RuleResponsibility> ruleResponsibilities;
    @XmlElementWrapper(name="ruleExtensions", required=false)
    @XmlElement(name="ruleExtension", required=false)
    private final List<RuleExtension> ruleExtensions;
    @XmlElement(name="ruleTemplateName", required=false)
    private final String ruleTemplateName;
    @XmlElement(name="ruleExpressionDef", required=false)
    private final RuleExpression ruleExpressionDef;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private Rule() {
        this.id = null;
        this.name = null;
        this.ruleTemplate = null;
        this.active = false;
        this.description = null;
        this.docTypeName = null;
        this.fromDate = null;
        this.toDate = null;
        this.fromDateValue = null;
        this.toDateValue = null;
        this.forceAction = false;
        this.ruleResponsibilities = null;
        this.ruleExtensions = null;
        this.ruleTemplateName = null;
        this.ruleExpressionDef = null;
        this.previousRuleId = null;
    }

    private Rule(Builder builder) {
        this.id = builder.getId();
        this.name = builder.getName();
        this.ruleTemplate = builder.getRuleTemplate() == null ? null : builder.getRuleTemplate().build();
        this.active = builder.isActive();
        this.description = builder.getDescription();
        this.docTypeName = builder.getDocTypeName();
        this.fromDate = builder.getFromDate();
        this.toDate = builder.getToDate();
        this.fromDateValue = builder.getFromDate();
        this.toDateValue = builder.getToDate();
        this.forceAction = builder.isForceAction();
        if (CollectionUtils.isNotEmpty(builder.getRuleResponsibilities())) {
            ArrayList<RuleResponsibility> responsibilities = new ArrayList<RuleResponsibility>();
            for (RuleResponsibility.Builder builder2 : builder.getRuleResponsibilities()) {
                responsibilities.add(builder2.build());
            }
            this.ruleResponsibilities = responsibilities;
        } else {
            this.ruleResponsibilities = Collections.emptyList();
        }
        if (CollectionUtils.isNotEmpty(builder.getRuleExtensions())) {
            ArrayList<RuleExtension> extensions = new ArrayList<RuleExtension>();
            for (RuleExtension.Builder builder3 : builder.getRuleExtensions()) {
                extensions.add(builder3.build());
            }
            this.ruleExtensions = extensions;
        } else {
            this.ruleExtensions = Collections.emptyList();
        }
        this.ruleTemplateName = builder.getRuleTemplateName();
        this.ruleExpressionDef = builder.getRuleExpressionDef() == null ? null : builder.getRuleExpressionDef().build();
        this.previousRuleId = builder.getPreviousRuleId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RuleTemplate getRuleTemplate() {
        return this.ruleTemplate;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPreviousRuleId() {
        return this.previousRuleId;
    }

    @Override
    public String getDocTypeName() {
        return this.docTypeName;
    }

    @Override
    public DateTime getFromDate() {
        return this.fromDateValue == null ? this.fromDate : this.fromDateValue;
    }

    @Override
    public DateTime getToDate() {
        return this.toDateValue == null ? this.toDate : this.toDateValue;
    }

    @Override
    public boolean isForceAction() {
        return this.forceAction;
    }

    public List<RuleResponsibility> getRuleResponsibilities() {
        return this.ruleResponsibilities;
    }

    public List<RuleExtension> getRuleExtensions() {
        return this.ruleExtensions;
    }

    public Map<String, String> getRuleExtensionMap() {
        HashMap<String, String> extensions = new HashMap<String, String>();
        for (RuleExtension ext : this.getRuleExtensions()) {
            extensions.putAll(ext.getExtensionValuesMap());
        }
        return Collections.unmodifiableMap(extensions);
    }

    @Override
    public String getRuleTemplateName() {
        return this.ruleTemplateName;
    }

    @Override
    public RuleExpression getRuleExpressionDef() {
        return this.ruleExpressionDef;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    RuleContract {
        private String id;
        private String name;
        private RuleTemplate.Builder ruleTemplate;
        private boolean active;
        private String description;
        private String docTypeName;
        private DateTime fromDate;
        private DateTime toDate;
        private boolean forceAction;
        private List<RuleResponsibility.Builder> ruleResponsibilities = Collections.emptyList();
        private List<RuleExtension.Builder> ruleExtensions = Collections.emptyList();
        private String ruleTemplateName;
        private String previousRuleId;
        private RuleExpression.Builder ruleExpressionDef;

        private Builder() {
            this.setActive(true);
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(RuleContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setId(contract.getId());
            builder.setName(contract.getName());
            builder.setRuleTemplate(contract.getRuleTemplate() == null ? null : RuleTemplate.Builder.create(contract.getRuleTemplate()));
            builder.setActive(contract.isActive());
            builder.setDescription(contract.getDescription());
            builder.setDocTypeName(contract.getDocTypeName());
            builder.setFromDate(contract.getFromDate());
            builder.setToDate(contract.getToDate());
            builder.setForceAction(contract.isForceAction());
            builder.setPreviousRuleId(contract.getPreviousRuleId());
            if (CollectionUtils.isNotEmpty(contract.getRuleResponsibilities())) {
                ArrayList<RuleResponsibility.Builder> responsibilityBuilders = new ArrayList<RuleResponsibility.Builder>();
                for (RuleResponsibilityContract ruleResponsibilityContract : contract.getRuleResponsibilities()) {
                    responsibilityBuilders.add(RuleResponsibility.Builder.create(ruleResponsibilityContract));
                }
                builder.setRuleResponsibilities(responsibilityBuilders);
            } else {
                builder.setRuleResponsibilities(Collections.emptyList());
            }
            if (CollectionUtils.isNotEmpty(contract.getRuleExtensions())) {
                ArrayList<RuleExtension.Builder> extensionBuilders = new ArrayList<RuleExtension.Builder>();
                for (RuleExtensionContract ruleExtensionContract : contract.getRuleExtensions()) {
                    extensionBuilders.add(RuleExtension.Builder.create(ruleExtensionContract));
                }
                builder.setRuleExtensions(extensionBuilders);
            } else {
                builder.setRuleExtensions(Collections.emptyList());
            }
            builder.setRuleTemplateName(contract.getRuleTemplateName());
            if (contract.getRuleExpressionDef() != null) {
                builder.setRuleExpressionDef(RuleExpression.Builder.create(contract.getRuleExpressionDef()));
            }
            return builder;
        }

        public Rule build() {
            return new Rule(this);
        }

        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public RuleTemplate.Builder getRuleTemplate() {
            return this.ruleTemplate;
        }

        @Override
        public boolean isActive() {
            return this.active;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getDocTypeName() {
            return this.docTypeName;
        }

        @Override
        public DateTime getFromDate() {
            return this.fromDate;
        }

        @Override
        public DateTime getToDate() {
            return this.toDate;
        }

        @Override
        public boolean isForceAction() {
            return this.forceAction;
        }

        @Override
        public String getPreviousRuleId() {
            return this.previousRuleId;
        }

        public List<RuleResponsibility.Builder> getRuleResponsibilities() {
            return this.ruleResponsibilities;
        }

        public List<RuleExtension.Builder> getRuleExtensions() {
            return this.ruleExtensions;
        }

        @Override
        public String getRuleTemplateName() {
            return this.ruleTemplateName;
        }

        @Override
        public RuleExpression.Builder getRuleExpressionDef() {
            return this.ruleExpressionDef;
        }

        public void setId(String id) {
            if (StringUtils.isWhitespace((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setRuleTemplate(RuleTemplate.Builder ruleTemplate) {
            this.ruleTemplate = ruleTemplate;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setDocTypeName(String docTypeName) {
            this.docTypeName = docTypeName;
        }

        public void setFromDate(DateTime fromDate) {
            this.fromDate = fromDate;
        }

        public void setToDate(DateTime toDate) {
            this.toDate = toDate;
        }

        public void setForceAction(boolean forceAction) {
            this.forceAction = forceAction;
        }

        public void setPreviousRuleId(String previousRuleId) {
            this.previousRuleId = previousRuleId;
        }

        public void setRuleResponsibilities(List<RuleResponsibility.Builder> ruleResponsibilities) {
            this.ruleResponsibilities = Collections.unmodifiableList(ruleResponsibilities);
        }

        public void setRuleExtensions(List<RuleExtension.Builder> ruleExtensions) {
            this.ruleExtensions = Collections.unmodifiableList(ruleExtensions);
        }

        public void setRuleTemplateName(String ruleTemplateName) {
            this.ruleTemplateName = ruleTemplateName;
        }

        public void setRuleExpressionDef(RuleExpression.Builder ruleExpressionDef) {
            this.ruleExpressionDef = ruleExpressionDef;
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kew/v2_0/RuleType";
    }

    static class Elements {
        static final String ID = "id";
        static final String NAME = "name";
        static final String RULE_TEMPLATE = "ruleTemplate";
        static final String ACTIVE = "active";
        static final String DESCRIPTION = "description";
        static final String DOC_TYPE_NAME = "docTypeName";
        static final String FROM_DATE = "fromDate";
        static final String TO_DATE = "toDate";
        static final String FROM_DATE_VALUE = "fromDateValue";
        static final String TO_DATE_VALUE = "toDateValue";
        static final String FORCE_ACTION = "forceAction";
        static final String RULE_RESPONSIBILITIES = "ruleResponsibilities";
        static final String RULE_RESPONSIBILITY = "ruleResponsibility";
        static final String RULE_EXTENSIONS = "ruleExtensions";
        static final String RULE_EXTENSION = "ruleExtension";
        static final String RULE_TEMPLATE_NAME = "ruleTemplateName";
        static final String RULE_EXPRESSION_DEF = "ruleExpressionDef";
        static final String PREVIOUS_VERSION_ID = "previousRuleId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "rule";
        static final String TYPE_NAME = "RuleType";

        Constants() {
        }
    }
}

