/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MultiValuedStringMapAdapter;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.document.DocumentStatusCategory;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteriaContract;
import org.kuali.rice.kew.api.document.search.RouteNodeLookupLogic;
import org.w3c.dom.Element;

@XmlRootElement(name="documentSearchCriteria")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentSearchCriteriaType", propOrder={"documentId", "documentStatuses", "documentStatusCategories", "title", "applicationDocumentId", "applicationDocumentStatus", "initiatorPrincipalName", "viewerPrincipalName", "groupViewerId", "groupViewerName", "approverPrincipalName", "routeNodeName", "routeNodeLookupLogic", "documentTypeName", "additionalDocumentTypeNames", "dateCreatedFrom", "dateCreatedTo", "dateLastModifiedFrom", "dateLastModifiedTo", "dateApprovedFrom", "dateApprovedTo", "dateFinalizedFrom", "dateFinalizedTo", "dateApplicationDocumentStatusChangedFrom", "dateApplicationDocumentStatusChangedTo", "documentAttributeValues", "saveName", "startAtIndex", "maxResults", "isAdvancedSearch", "searchOptions", "applicationDocumentStatuses", "docSearchUserId", "initiatorPrincipalId", "viewerPrincipalId", "approverPrincipalId", "_futureElements"})
public final class DocumentSearchCriteria
extends AbstractDataTransferObject
implements DocumentSearchCriteriaContract {
    private static final long serialVersionUID = -221440103480740497L;
    @XmlElement(name="documentId", required=false)
    private final String documentId;
    @XmlElementWrapper(name="documentStatuses", required=false)
    @XmlElement(name="documentStatus", required=false)
    private final List<DocumentStatus> documentStatuses;
    @XmlElementWrapper(name="documentStatusCategories", required=false)
    @XmlElement(name="documentStatusCategory", required=false)
    private final List<DocumentStatusCategory> documentStatusCategories;
    @XmlElement(name="title", required=false)
    private final String title;
    @XmlElement(name="applicationDocumentId", required=false)
    private final String applicationDocumentId;
    @XmlElement(name="applicationDocumentStatus", required=false)
    private final String applicationDocumentStatus;
    @XmlElement(name="initiatorPrincipalName", required=false)
    private final String initiatorPrincipalName;
    @XmlElement(name="initiatorPrincipalId", required=false)
    private final String initiatorPrincipalId;
    @XmlElement(name="viewerPrincipalName", required=false)
    private final String viewerPrincipalName;
    @XmlElement(name="viewerPrincipalId", required=false)
    private final String viewerPrincipalId;
    @XmlElement(name="groupViewerId", required=false)
    private final String groupViewerId;
    @XmlElement(name="groupViewerName", required=false)
    private final String groupViewerName;
    @XmlElement(name="approverPrincipalName", required=false)
    private final String approverPrincipalName;
    @XmlElement(name="approverPrincipalId", required=false)
    private final String approverPrincipalId;
    @XmlElement(name="routeNodeName", required=false)
    private final String routeNodeName;
    @XmlElement(name="routeNodeLookupLogic", required=false)
    private final RouteNodeLookupLogic routeNodeLookupLogic;
    @XmlElement(name="documentTypeName", required=false)
    private final String documentTypeName;
    @XmlElementWrapper(name="additionalDocumentTypeNames", required=false)
    @XmlElement(name="additionalDocumentTypeName", required=false)
    private final List<String> additionalDocumentTypeNames;
    @XmlElement(name="dateCreatedFrom", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateCreatedFrom;
    @XmlElement(name="dateCreatedTo", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateCreatedTo;
    @XmlElement(name="dateLastModifiedFrom", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateLastModifiedFrom;
    @XmlElement(name="dateLastModifiedTo", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateLastModifiedTo;
    @XmlElement(name="dateApprovedFrom", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateApprovedFrom;
    @XmlElement(name="dateApprovedTo", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateApprovedTo;
    @XmlElement(name="dateFinalizedFrom", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateFinalizedFrom;
    @XmlElement(name="dateFinalizedTo", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateFinalizedTo;
    @XmlElement(name="dateApplicationDocumentStatusChangedFrom", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateApplicationDocumentStatusChangedFrom;
    @XmlElement(name="dateApplicationDocumentStatusChangedTo", required=false)
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private final DateTime dateApplicationDocumentStatusChangedTo;
    @XmlElement(name="documentAttributeValues", required=false)
    @XmlJavaTypeAdapter(value=MultiValuedStringMapAdapter.class)
    private final Map<String, List<String>> documentAttributeValues;
    @XmlElement(name="saveName", required=false)
    private final String saveName;
    @XmlElement(name="startAtIndex", required=false)
    private final Integer startAtIndex;
    @XmlElement(name="maxResults", required=false)
    private final Integer maxResults;
    @XmlElement(name="isAdvancedSearch", required=false)
    private final String isAdvancedSearch;
    @XmlElement(name="searchOptions", required=false)
    @XmlJavaTypeAdapter(value=MultiValuedStringMapAdapter.class)
    private final Map<String, List<String>> searchOptions;
    @XmlElement(name="applicationDocumentStatus", required=false)
    @XmlElementWrapper(name="applicationDocumentStatuses", required=false)
    private final List<String> applicationDocumentStatuses;
    @XmlElement(name="docSearchUserId", required=false)
    private final String docSearchUserId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentSearchCriteria() {
        this.documentId = null;
        this.documentStatuses = null;
        this.documentStatusCategories = null;
        this.title = null;
        this.applicationDocumentId = null;
        this.applicationDocumentStatus = null;
        this.initiatorPrincipalName = null;
        this.initiatorPrincipalId = null;
        this.viewerPrincipalName = null;
        this.viewerPrincipalId = null;
        this.groupViewerId = null;
        this.groupViewerName = null;
        this.approverPrincipalName = null;
        this.approverPrincipalId = null;
        this.routeNodeName = null;
        this.routeNodeLookupLogic = null;
        this.documentTypeName = null;
        this.additionalDocumentTypeNames = null;
        this.dateCreatedFrom = null;
        this.dateCreatedTo = null;
        this.dateLastModifiedFrom = null;
        this.dateLastModifiedTo = null;
        this.dateApprovedFrom = null;
        this.dateApprovedTo = null;
        this.dateFinalizedFrom = null;
        this.dateFinalizedTo = null;
        this.dateApplicationDocumentStatusChangedFrom = null;
        this.dateApplicationDocumentStatusChangedTo = null;
        this.documentAttributeValues = null;
        this.searchOptions = null;
        this.saveName = null;
        this.startAtIndex = null;
        this.maxResults = null;
        this.isAdvancedSearch = null;
        this.docSearchUserId = null;
        this.applicationDocumentStatuses = null;
    }

    private DocumentSearchCriteria(Builder builder) {
        this.documentId = builder.getDocumentId();
        this.documentStatuses = ModelObjectUtils.createImmutableCopy(builder.getDocumentStatuses());
        this.documentStatusCategories = ModelObjectUtils.createImmutableCopy(builder.getDocumentStatusCategories());
        this.title = builder.getTitle();
        this.applicationDocumentId = builder.getApplicationDocumentId();
        this.applicationDocumentStatus = builder.getApplicationDocumentStatus();
        this.initiatorPrincipalName = builder.getInitiatorPrincipalName();
        this.initiatorPrincipalId = builder.getInitiatorPrincipalId();
        this.viewerPrincipalName = builder.getViewerPrincipalName();
        this.viewerPrincipalId = builder.getViewerPrincipalId();
        this.groupViewerId = builder.getGroupViewerId();
        this.groupViewerName = builder.getGroupViewerName();
        this.approverPrincipalName = builder.getApproverPrincipalName();
        this.approverPrincipalId = builder.getApproverPrincipalId();
        this.routeNodeName = builder.getRouteNodeName();
        this.routeNodeLookupLogic = builder.getRouteNodeLookupLogic();
        this.documentTypeName = builder.getDocumentTypeName();
        this.additionalDocumentTypeNames = ModelObjectUtils.createImmutableCopy(builder.getAdditionalDocumentTypeNames());
        this.dateCreatedFrom = builder.getDateCreatedFrom();
        this.dateCreatedTo = builder.getDateCreatedTo();
        this.dateLastModifiedFrom = builder.getDateLastModifiedFrom();
        this.dateLastModifiedTo = builder.getDateLastModifiedTo();
        this.dateApprovedFrom = builder.getDateApprovedFrom();
        this.dateApprovedTo = builder.getDateApprovedTo();
        this.dateFinalizedFrom = builder.getDateFinalizedFrom();
        this.dateFinalizedTo = builder.getDateFinalizedTo();
        this.dateApplicationDocumentStatusChangedFrom = builder.getDateApplicationDocumentStatusChangedFrom();
        this.dateApplicationDocumentStatusChangedTo = builder.getDateApplicationDocumentStatusChangedTo();
        this.documentAttributeValues = ModelObjectUtils.createImmutableCopy(builder.getDocumentAttributeValues());
        this.searchOptions = ModelObjectUtils.createImmutableCopy(builder.getSearchOptions());
        this.saveName = builder.getSaveName();
        this.startAtIndex = builder.getStartAtIndex();
        this.maxResults = builder.getMaxResults();
        this.isAdvancedSearch = builder.getIsAdvancedSearch();
        this.docSearchUserId = builder.getDocSearchUserId();
        this.applicationDocumentStatuses = builder.getApplicationDocumentStatuses();
    }

    @Override
    public String getDocumentId() {
        return this.documentId;
    }

    @Override
    public List<DocumentStatus> getDocumentStatuses() {
        return this.documentStatuses;
    }

    @Override
    public List<DocumentStatusCategory> getDocumentStatusCategories() {
        return this.documentStatusCategories;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getApplicationDocumentId() {
        return this.applicationDocumentId;
    }

    @Override
    @Deprecated
    public String getApplicationDocumentStatus() {
        return this.applicationDocumentStatus;
    }

    @Override
    @Deprecated
    public String getInitiatorPrincipalName() {
        return this.initiatorPrincipalName;
    }

    @Override
    public String getInitiatorPrincipalId() {
        return this.initiatorPrincipalId;
    }

    @Override
    @Deprecated
    public String getViewerPrincipalName() {
        return this.viewerPrincipalName;
    }

    @Override
    public String getViewerPrincipalId() {
        return this.viewerPrincipalId;
    }

    @Override
    public String getGroupViewerId() {
        return this.groupViewerId;
    }

    @Override
    public String getGroupViewerName() {
        return this.groupViewerName;
    }

    @Override
    @Deprecated
    public String getApproverPrincipalName() {
        return this.approverPrincipalName;
    }

    @Override
    public String getApproverPrincipalId() {
        return this.approverPrincipalId;
    }

    @Override
    public String getRouteNodeName() {
        return this.routeNodeName;
    }

    @Override
    public RouteNodeLookupLogic getRouteNodeLookupLogic() {
        return this.routeNodeLookupLogic;
    }

    @Override
    public String getDocumentTypeName() {
        return this.documentTypeName;
    }

    @Override
    public List<String> getAdditionalDocumentTypeNames() {
        return this.additionalDocumentTypeNames;
    }

    @Override
    public DateTime getDateCreatedFrom() {
        return this.dateCreatedFrom;
    }

    @Override
    public DateTime getDateCreatedTo() {
        return this.dateCreatedTo;
    }

    @Override
    public DateTime getDateLastModifiedFrom() {
        return this.dateLastModifiedFrom;
    }

    @Override
    public DateTime getDateLastModifiedTo() {
        return this.dateLastModifiedTo;
    }

    @Override
    public DateTime getDateApprovedFrom() {
        return this.dateApprovedFrom;
    }

    @Override
    public DateTime getDateApprovedTo() {
        return this.dateApprovedTo;
    }

    @Override
    public DateTime getDateFinalizedFrom() {
        return this.dateFinalizedFrom;
    }

    @Override
    public DateTime getDateFinalizedTo() {
        return this.dateFinalizedTo;
    }

    @Override
    public DateTime getDateApplicationDocumentStatusChangedFrom() {
        return this.dateApplicationDocumentStatusChangedFrom;
    }

    @Override
    public DateTime getDateApplicationDocumentStatusChangedTo() {
        return this.dateApplicationDocumentStatusChangedTo;
    }

    @Override
    public Map<String, List<String>> getDocumentAttributeValues() {
        return this.documentAttributeValues;
    }

    @Override
    public Map<String, List<String>> getSearchOptions() {
        return this.searchOptions;
    }

    @Override
    public String getSaveName() {
        return this.saveName;
    }

    @Override
    public Integer getStartAtIndex() {
        return this.startAtIndex;
    }

    @Override
    public Integer getMaxResults() {
        return this.maxResults;
    }

    @Override
    public String getIsAdvancedSearch() {
        return this.isAdvancedSearch;
    }

    @Override
    public List<String> getApplicationDocumentStatuses() {
        return this.applicationDocumentStatuses;
    }

    @Override
    public String getDocSearchUserId() {
        return this.docSearchUserId;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentSearchCriteriaContract {
        private String documentId;
        private List<DocumentStatus> documentStatuses;
        private List<DocumentStatusCategory> documentStatusCategories;
        private String title;
        private String applicationDocumentId;
        private String applicationDocumentStatus;
        private String initiatorPrincipalName;
        private String initiatorPrincipalId;
        private String viewerPrincipalName;
        private String viewerPrincipalId;
        private String groupViewerId;
        private String groupViewerName;
        private String approverPrincipalName;
        private String approverPrincipalId;
        private String routeNodeName;
        private RouteNodeLookupLogic routeNodeLookupLogic;
        private String documentTypeName;
        private List<String> additionalDocumentTypeNames;
        private DateTime dateCreatedFrom;
        private DateTime dateCreatedTo;
        private DateTime dateLastModifiedFrom;
        private DateTime dateLastModifiedTo;
        private DateTime dateApprovedFrom;
        private DateTime dateApprovedTo;
        private DateTime dateFinalizedFrom;
        private DateTime dateFinalizedTo;
        private DateTime dateApplicationDocumentStatusChangedFrom;
        private DateTime dateApplicationDocumentStatusChangedTo;
        private Map<String, List<String>> documentAttributeValues;
        private Map<String, List<String>> searchOptions;
        private String saveName;
        private Integer startAtIndex;
        private Integer maxResults;
        private String isAdvancedSearch;
        private String docSearchUserId;
        private List<String> applicationDocumentStatuses;

        private Builder() {
            this.setDocumentStatuses(new ArrayList<DocumentStatus>());
            this.setDocumentStatusCategories(new ArrayList<DocumentStatusCategory>());
            this.setAdditionalDocumentTypeNames(new ArrayList<String>());
            this.setDocumentAttributeValues(new HashMap<String, List<String>>());
            this.setSearchOptions(new HashMap<String, List<String>>());
            this.setApplicationDocumentStatuses(new ArrayList<String>());
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(DocumentSearchCriteriaContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create();
            builder.setDocumentId(contract.getDocumentId());
            if (contract.getDocumentStatuses() != null) {
                builder.setDocumentStatuses(new ArrayList<DocumentStatus>(contract.getDocumentStatuses()));
            }
            if (contract.getDocumentStatusCategories() != null) {
                builder.setDocumentStatusCategories(new ArrayList<DocumentStatusCategory>(contract.getDocumentStatusCategories()));
            }
            builder.setTitle(contract.getTitle());
            builder.setApplicationDocumentId(contract.getApplicationDocumentId());
            builder.setInitiatorPrincipalName(contract.getInitiatorPrincipalName());
            builder.setInitiatorPrincipalId(contract.getInitiatorPrincipalId());
            builder.setViewerPrincipalName(contract.getViewerPrincipalName());
            builder.setViewerPrincipalId(contract.getViewerPrincipalId());
            builder.setGroupViewerId(contract.getGroupViewerId());
            builder.setGroupViewerName(contract.getGroupViewerName());
            builder.setApproverPrincipalName(contract.getApproverPrincipalName());
            builder.setApproverPrincipalId(contract.getApproverPrincipalId());
            builder.setRouteNodeName(contract.getRouteNodeName());
            builder.setRouteNodeLookupLogic(contract.getRouteNodeLookupLogic());
            builder.setDocumentTypeName(contract.getDocumentTypeName());
            if (contract.getAdditionalDocumentTypeNames() != null) {
                builder.setAdditionalDocumentTypeNames(new ArrayList<String>(contract.getAdditionalDocumentTypeNames()));
            }
            builder.setDateCreatedFrom(contract.getDateCreatedFrom());
            builder.setDateCreatedTo(contract.getDateCreatedTo());
            builder.setDateLastModifiedFrom(contract.getDateLastModifiedFrom());
            builder.setDateLastModifiedTo(contract.getDateLastModifiedTo());
            builder.setDateApprovedFrom(contract.getDateApprovedFrom());
            builder.setDateApprovedTo(contract.getDateApprovedTo());
            builder.setDateFinalizedFrom(contract.getDateFinalizedFrom());
            builder.setDateFinalizedTo(contract.getDateFinalizedTo());
            builder.setDateApplicationDocumentStatusChangedFrom(contract.getDateApplicationDocumentStatusChangedFrom());
            builder.setDateApplicationDocumentStatusChangedTo(contract.getDateApplicationDocumentStatusChangedTo());
            if (contract.getDocumentAttributeValues() != null) {
                builder.setDocumentAttributeValues(new HashMap<String, List<String>>(contract.getDocumentAttributeValues()));
            }
            if (contract.getSearchOptions() != null) {
                builder.setSearchOptions(new HashMap<String, List<String>>(contract.getSearchOptions()));
            }
            builder.setSaveName(contract.getSaveName());
            builder.setStartAtIndex(contract.getStartAtIndex());
            builder.setMaxResults(contract.getMaxResults());
            builder.setIsAdvancedSearch(contract.getIsAdvancedSearch());
            builder.setApplicationDocumentStatuses(contract.getApplicationDocumentStatuses());
            builder.setApplicationDocumentStatus(contract.getApplicationDocumentStatus());
            builder.setDocSearchUserId(contract.getDocSearchUserId());
            return builder;
        }

        public DocumentSearchCriteria build() {
            if (StringUtils.isNotBlank((String)this.routeNodeName) && StringUtils.isBlank((String)this.documentTypeName)) {
                throw new IllegalStateException("documentTypeName must be set if routeNodeName is set.");
            }
            return new DocumentSearchCriteria(this);
        }

        @Override
        public String getDocumentId() {
            return this.documentId;
        }

        @Override
        public List<DocumentStatus> getDocumentStatuses() {
            return this.documentStatuses;
        }

        @Override
        public List<DocumentStatusCategory> getDocumentStatusCategories() {
            return this.documentStatusCategories;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getApplicationDocumentId() {
            return this.applicationDocumentId;
        }

        @Override
        @Deprecated
        public String getApplicationDocumentStatus() {
            return this.applicationDocumentStatus;
        }

        @Override
        @Deprecated
        public String getInitiatorPrincipalName() {
            return this.initiatorPrincipalName;
        }

        @Override
        public String getInitiatorPrincipalId() {
            return this.initiatorPrincipalId;
        }

        @Override
        @Deprecated
        public String getViewerPrincipalName() {
            return this.viewerPrincipalName;
        }

        @Override
        public String getViewerPrincipalId() {
            return this.viewerPrincipalId;
        }

        @Override
        public String getGroupViewerId() {
            return this.groupViewerId;
        }

        @Override
        public String getGroupViewerName() {
            return this.groupViewerName;
        }

        @Override
        @Deprecated
        public String getApproverPrincipalName() {
            return this.approverPrincipalName;
        }

        @Override
        public String getApproverPrincipalId() {
            return this.approverPrincipalId;
        }

        @Override
        public String getRouteNodeName() {
            return this.routeNodeName;
        }

        @Override
        public RouteNodeLookupLogic getRouteNodeLookupLogic() {
            return this.routeNodeLookupLogic;
        }

        @Override
        public String getDocumentTypeName() {
            return this.documentTypeName;
        }

        @Override
        public List<String> getAdditionalDocumentTypeNames() {
            return this.additionalDocumentTypeNames;
        }

        @Override
        public DateTime getDateCreatedFrom() {
            return this.dateCreatedFrom;
        }

        @Override
        public DateTime getDateCreatedTo() {
            return this.dateCreatedTo;
        }

        @Override
        public DateTime getDateLastModifiedFrom() {
            return this.dateLastModifiedFrom;
        }

        @Override
        public DateTime getDateLastModifiedTo() {
            return this.dateLastModifiedTo;
        }

        @Override
        public DateTime getDateApprovedFrom() {
            return this.dateApprovedFrom;
        }

        @Override
        public DateTime getDateApprovedTo() {
            return this.dateApprovedTo;
        }

        @Override
        public DateTime getDateFinalizedFrom() {
            return this.dateFinalizedFrom;
        }

        @Override
        public DateTime getDateFinalizedTo() {
            return this.dateFinalizedTo;
        }

        @Override
        public DateTime getDateApplicationDocumentStatusChangedFrom() {
            return this.dateApplicationDocumentStatusChangedFrom;
        }

        @Override
        public DateTime getDateApplicationDocumentStatusChangedTo() {
            return this.dateApplicationDocumentStatusChangedTo;
        }

        @Override
        public Map<String, List<String>> getDocumentAttributeValues() {
            return this.documentAttributeValues;
        }

        @Override
        public Map<String, List<String>> getSearchOptions() {
            return this.searchOptions;
        }

        @Override
        public String getSaveName() {
            return this.saveName;
        }

        @Override
        public Integer getStartAtIndex() {
            return this.startAtIndex;
        }

        @Override
        public Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public String getIsAdvancedSearch() {
            return this.isAdvancedSearch;
        }

        @Override
        public List<String> getApplicationDocumentStatuses() {
            return this.applicationDocumentStatuses;
        }

        @Override
        public String getDocSearchUserId() {
            return this.docSearchUserId;
        }

        public void setDocumentId(String documentId) {
            this.documentId = documentId;
        }

        public void setDocumentStatuses(List<DocumentStatus> documentStatuses) {
            this.documentStatuses = documentStatuses;
        }

        public void setDocumentStatusCategories(List<DocumentStatusCategory> documentStatusCategories) {
            this.documentStatusCategories = documentStatusCategories;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setApplicationDocumentId(String applicationDocumentId) {
            this.applicationDocumentId = applicationDocumentId;
        }

        @Deprecated
        public void setApplicationDocumentStatus(String applicationDocumentStatus) {
            this.applicationDocumentStatus = applicationDocumentStatus;
        }

        @Deprecated
        public void setInitiatorPrincipalName(String initiatorPrincipalName) {
            this.initiatorPrincipalName = initiatorPrincipalName;
        }

        public void setInitiatorPrincipalId(String initiatorPrincipalId) {
            this.initiatorPrincipalId = initiatorPrincipalId;
        }

        @Deprecated
        public void setViewerPrincipalName(String viewerPrincipalName) {
            this.viewerPrincipalName = viewerPrincipalName;
        }

        public void setViewerPrincipalId(String viewerPrincipalId) {
            this.viewerPrincipalId = viewerPrincipalId;
        }

        public void setGroupViewerId(String groupViewerId) {
            this.groupViewerId = groupViewerId;
        }

        public void setGroupViewerName(String groupViewerName) {
            this.groupViewerName = groupViewerName;
        }

        @Deprecated
        public void setApproverPrincipalName(String approverPrincipalName) {
            this.approverPrincipalName = approverPrincipalName;
        }

        public void setApproverPrincipalId(String approverPrincipalId) {
            this.approverPrincipalId = approverPrincipalId;
        }

        public void setRouteNodeName(String routeNodeName) {
            this.routeNodeName = routeNodeName;
        }

        public void setRouteNodeLookupLogic(RouteNodeLookupLogic routeNodeLookupLogic) {
            this.routeNodeLookupLogic = routeNodeLookupLogic;
        }

        public void setDocumentTypeName(String documentTypeName) {
            this.documentTypeName = documentTypeName;
        }

        public void setAdditionalDocumentTypeNames(List<String> additionalDocumentTypeNames) {
            this.additionalDocumentTypeNames = additionalDocumentTypeNames;
        }

        public void setDateCreatedFrom(DateTime dateCreatedFrom) {
            this.dateCreatedFrom = dateCreatedFrom;
        }

        public void setDateCreatedTo(DateTime dateCreatedTo) {
            this.dateCreatedTo = dateCreatedTo;
        }

        public void setDateLastModifiedFrom(DateTime dateLastModifiedFrom) {
            this.dateLastModifiedFrom = dateLastModifiedFrom;
        }

        public void setDateLastModifiedTo(DateTime dateLastModifiedTo) {
            this.dateLastModifiedTo = dateLastModifiedTo;
        }

        public void setDateApprovedFrom(DateTime dateApprovedFrom) {
            this.dateApprovedFrom = dateApprovedFrom;
        }

        public void setDateApprovedTo(DateTime dateApprovedTo) {
            this.dateApprovedTo = dateApprovedTo;
        }

        public void setDateFinalizedFrom(DateTime dateFinalizedFrom) {
            this.dateFinalizedFrom = dateFinalizedFrom;
        }

        public void setDateFinalizedTo(DateTime dateFinalizedTo) {
            this.dateFinalizedTo = dateFinalizedTo;
        }

        public void setDateApplicationDocumentStatusChangedFrom(DateTime dateApplicationDocumentStatusChangedFrom) {
            this.dateApplicationDocumentStatusChangedFrom = dateApplicationDocumentStatusChangedFrom;
        }

        public void setDateApplicationDocumentStatusChangedTo(DateTime dateApplicationDocumentStatusChangedTo) {
            this.dateApplicationDocumentStatusChangedTo = dateApplicationDocumentStatusChangedTo;
        }

        public void setDocumentAttributeValues(Map<String, List<String>> documentAttributeValues) {
            this.documentAttributeValues = documentAttributeValues;
        }

        public void addDocumentAttributeValue(String name, String value) {
            if (StringUtils.isBlank((String)value)) {
                throw new IllegalArgumentException("value was null or blank");
            }
            List<String> values = this.getDocumentAttributeValues().get(name);
            if (values == null) {
                values = new ArrayList<String>();
                this.getDocumentAttributeValues().put(name, values);
            }
            values.add(value);
        }

        public void setSearchOptions(Map<String, List<String>> searchOptions) {
            this.searchOptions = searchOptions;
        }

        public void setSaveName(String saveName) {
            this.saveName = saveName;
        }

        public void setStartAtIndex(Integer startAtIndex) {
            this.startAtIndex = startAtIndex;
        }

        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public void setIsAdvancedSearch(String isAdvancedSearch) {
            this.isAdvancedSearch = isAdvancedSearch;
        }

        public void setApplicationDocumentStatuses(List<String> applicationDocumentStatuses) {
            this.applicationDocumentStatuses = applicationDocumentStatuses;
        }

        public void setDocSearchUserId(String docSearchUserId) {
            this.docSearchUserId = docSearchUserId;
        }

        public void normalizeDateTimes() {
            if (this.dateCreatedFrom != null) {
                this.dateCreatedFrom = this.dateCreatedFrom.withZone(DateTimeZone.getDefault());
            }
            if (this.dateCreatedTo != null) {
                this.dateCreatedTo = this.dateCreatedTo.withZone(DateTimeZone.getDefault());
            }
            if (this.dateLastModifiedFrom != null) {
                this.dateLastModifiedFrom = this.dateLastModifiedFrom.withZone(DateTimeZone.getDefault());
            }
            if (this.dateLastModifiedTo != null) {
                this.dateLastModifiedTo = this.dateLastModifiedTo.withZone(DateTimeZone.getDefault());
            }
            if (this.dateApprovedFrom != null) {
                this.dateApprovedFrom = this.dateApprovedFrom.withZone(DateTimeZone.getDefault());
            }
            if (this.dateApprovedTo != null) {
                this.dateApprovedTo = this.dateApprovedTo.withZone(DateTimeZone.getDefault());
            }
            if (this.dateFinalizedFrom != null) {
                this.dateFinalizedFrom = this.dateFinalizedFrom.withZone(DateTimeZone.getDefault());
            }
            if (this.dateFinalizedTo != null) {
                this.dateFinalizedTo = this.dateFinalizedTo.withZone(DateTimeZone.getDefault());
            }
            if (this.dateApplicationDocumentStatusChangedFrom != null) {
                this.dateApplicationDocumentStatusChangedFrom = this.dateApplicationDocumentStatusChangedFrom.withZone(DateTimeZone.getDefault());
            }
            if (this.dateApplicationDocumentStatusChangedTo != null) {
                this.dateApplicationDocumentStatusChangedTo = this.dateApplicationDocumentStatusChangedTo.withZone(DateTimeZone.getDefault());
            }
        }
    }

    static class Elements {
        static final String DOCUMENT_ID = "documentId";
        static final String DOCUMENT_STATUSES = "documentStatuses";
        static final String DOCUMENT_STATUS = "documentStatus";
        static final String DOCUMENT_STATUS_CATEGORIES = "documentStatusCategories";
        static final String DOCUMENT_STATUS_CATEGORY = "documentStatusCategory";
        static final String TITLE = "title";
        static final String APPLICATION_DOCUMENT_ID = "applicationDocumentId";
        static final String APPLICATION_DOCUMENT_STATUS = "applicationDocumentStatus";
        static final String INITIATOR_PRINCIPAL_NAME = "initiatorPrincipalName";
        static final String INITIATOR_PRINCIPAL_ID = "initiatorPrincipalId";
        static final String VIEWER_PRINCIPAL_NAME = "viewerPrincipalName";
        static final String VIEWER_PRINCIPAL_ID = "viewerPrincipalId";
        static final String GROUP_VIEWER_ID = "groupViewerId";
        static final String GROUP_VIEWER_NAME = "groupViewerName";
        static final String APPROVER_PRINCIPAL_NAME = "approverPrincipalName";
        static final String APPROVER_PRINCIPAL_ID = "approverPrincipalId";
        static final String ROUTE_NODE_NAME = "routeNodeName";
        static final String ROUTE_NODE_LOOKUP_LOGIC = "routeNodeLookupLogic";
        static final String DOCUMENT_TYPE_NAME = "documentTypeName";
        static final String ADDITIONAL_DOCUMENT_TYPE_NAMES = "additionalDocumentTypeNames";
        static final String ADDITIONAL_DOCUMENT_TYPE_NAME = "additionalDocumentTypeName";
        static final String DATE_CREATED_FROM = "dateCreatedFrom";
        static final String DATE_CREATED_TO = "dateCreatedTo";
        static final String DATE_LAST_MODIFIED_FROM = "dateLastModifiedFrom";
        static final String DATE_LAST_MODIFIED_TO = "dateLastModifiedTo";
        static final String DATE_APPROVED_FROM = "dateApprovedFrom";
        static final String DATE_APPROVED_TO = "dateApprovedTo";
        static final String DATE_FINALIZED_FROM = "dateFinalizedFrom";
        static final String DATE_FINALIZED_TO = "dateFinalizedTo";
        static final String DATE_APPLICATION_DOCUMENT_STATUS_CHANGED_FROM = "dateApplicationDocumentStatusChangedFrom";
        static final String DATE_APPLICATION_DOCUMENT_STATUS_CHANGED_TO = "dateApplicationDocumentStatusChangedTo";
        static final String DOCUMENT_ATTRIBUTE_VALUES = "documentAttributeValues";
        static final String SAVE_NAME = "saveName";
        static final String START_AT_INDEX = "startAtIndex";
        static final String MAX_RESULTS = "maxResults";
        static final String IS_ADVANCED_SEARCH = "isAdvancedSearch";
        static final String SEARCH_OPTIONS = "searchOptions";
        static final String APPLICATION_DOCUMENT_STATUSES = "applicationDocumentStatuses";
        static final String DOC_SEARCH_USER_ID = "docSearchUserId";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentSearchCriteria";
        static final String TYPE_NAME = "DocumentSearchCriteriaType";

        Constants() {
        }
    }
}

