/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.api.document.search;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.mo.ModelObjectUtils;
import org.kuali.rice.kew.api.document.search.DocumentSearchCriteria;
import org.kuali.rice.kew.api.document.search.DocumentSearchResult;
import org.kuali.rice.kew.api.document.search.DocumentSearchResultContract;
import org.kuali.rice.kew.api.document.search.DocumentSearchResultsContract;
import org.w3c.dom.Element;

@XmlRootElement(name="documentSearchResults")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="DocumentSearchResultsType", propOrder={"searchResults", "criteria", "criteriaModified", "overThreshold", "numberOfSecurityFilteredResults", "_futureElements"})
public final class DocumentSearchResults
extends AbstractDataTransferObject
implements DocumentSearchResultsContract {
    @XmlElementWrapper(name="searchResults", required=true)
    @XmlElement(name="searchResult", required=false)
    private final List<DocumentSearchResult> searchResults;
    @XmlElement(name="criteria", required=true)
    private final DocumentSearchCriteria criteria;
    @XmlElement(name="criteriaModified", required=true)
    private final boolean criteriaModified;
    @XmlElement(name="overThreshold", required=true)
    private final boolean overThreshold;
    @XmlElement(name="numberOfSecurityFilteredResults", required=true)
    private final int numberOfSecurityFilteredResults;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private DocumentSearchResults() {
        this.searchResults = null;
        this.criteria = null;
        this.criteriaModified = false;
        this.overThreshold = false;
        this.numberOfSecurityFilteredResults = 0;
    }

    private DocumentSearchResults(Builder builder) {
        this.searchResults = ModelObjectUtils.buildImmutableCopy(builder.getSearchResults());
        this.criteria = builder.getCriteria().build();
        this.criteriaModified = builder.isCriteriaModified();
        this.overThreshold = builder.isOverThreshold();
        this.numberOfSecurityFilteredResults = builder.getNumberOfSecurityFilteredResults();
    }

    public List<DocumentSearchResult> getSearchResults() {
        return this.searchResults;
    }

    @Override
    public DocumentSearchCriteria getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean isCriteriaModified() {
        return this.criteriaModified;
    }

    @Override
    public boolean isOverThreshold() {
        return this.overThreshold;
    }

    @Override
    public int getNumberOfSecurityFilteredResults() {
        return this.numberOfSecurityFilteredResults;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    DocumentSearchResultsContract {
        private List<DocumentSearchResult.Builder> searchResults;
        private DocumentSearchCriteria.Builder criteria;
        private boolean criteriaModified;
        private boolean overThreshold;
        private int numberOfSecurityFilteredResults;

        private Builder(DocumentSearchCriteria.Builder criteria) {
            this.setSearchResults(new ArrayList<DocumentSearchResult.Builder>());
            this.setCriteria(criteria);
            this.setCriteriaModified(false);
            this.setOverThreshold(false);
            this.setNumberOfSecurityFilteredResults(0);
        }

        public static Builder create(DocumentSearchCriteria.Builder criteria) {
            return new Builder(criteria);
        }

        public static Builder create(DocumentSearchResultsContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(DocumentSearchCriteria.Builder.create(contract.getCriteria()));
            if (!CollectionUtils.isEmpty(contract.getSearchResults())) {
                for (DocumentSearchResultContract documentSearchResultContract : contract.getSearchResults()) {
                    builder.getSearchResults().add(DocumentSearchResult.Builder.create(documentSearchResultContract));
                }
            }
            builder.setCriteriaModified(contract.isCriteriaModified());
            builder.setOverThreshold(contract.isOverThreshold());
            builder.setNumberOfSecurityFilteredResults(contract.getNumberOfSecurityFilteredResults());
            return builder;
        }

        public DocumentSearchResults build() {
            return new DocumentSearchResults(this);
        }

        public List<DocumentSearchResult.Builder> getSearchResults() {
            return this.searchResults;
        }

        @Override
        public DocumentSearchCriteria.Builder getCriteria() {
            return this.criteria;
        }

        @Override
        public boolean isCriteriaModified() {
            return this.criteriaModified;
        }

        @Override
        public boolean isOverThreshold() {
            return this.overThreshold;
        }

        @Override
        public int getNumberOfSecurityFilteredResults() {
            return this.numberOfSecurityFilteredResults;
        }

        public void setSearchResults(List<DocumentSearchResult.Builder> searchResults) {
            this.searchResults = searchResults;
        }

        public void setCriteria(DocumentSearchCriteria.Builder criteria) {
            if (criteria == null) {
                throw new IllegalArgumentException("criteria was null");
            }
            this.criteria = criteria;
        }

        public void setCriteriaModified(boolean criteriaModified) {
            this.criteriaModified = criteriaModified;
        }

        public void setOverThreshold(boolean overThreshold) {
            this.overThreshold = overThreshold;
        }

        public void setNumberOfSecurityFilteredResults(int numberOfSecurityFilteredResults) {
            this.numberOfSecurityFilteredResults = numberOfSecurityFilteredResults;
        }
    }

    static class Elements {
        static final String SEARCH_RESULTS = "searchResults";
        static final String SEARCH_RESULT = "searchResult";
        static final String CRITERIA = "criteria";
        static final String CRITERIA_MODIFIED = "criteriaModified";
        static final String OVER_THRESHOLD = "overThreshold";
        static final String NUMBER_OF_SECURITY_FILTERED_RESULTS = "numberOfSecurityFilteredResults";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "documentSearchResults";
        static final String TYPE_NAME = "DocumentSearchResultsType";

        Constants() {
        }
    }
}

