/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.doctype;

import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;

import javax.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * TODO...
 * 
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 *
 */
class DocumentTypePolicyMapAdapter extends XmlAdapter<MapStringStringAdapter.StringMapEntryList, Map<DocumentTypePolicy, String>> {

	@Override
	public MapStringStringAdapter.StringMapEntryList marshal(Map<DocumentTypePolicy, String> map) {
	    List<MapStringStringAdapter.StringMapEntry> entries = new ArrayList<MapStringStringAdapter.StringMapEntry>();
	    if (map != null) {
	        for (DocumentTypePolicy policy : map.keySet()) {
	            entries.add(new MapStringStringAdapter.StringMapEntry(policy.getCode(), map.get(policy)));
	        }
	    }
	    return new MapStringStringAdapter.StringMapEntryList(entries);
	}

	@Override
	public Map<DocumentTypePolicy, String> unmarshal(MapStringStringAdapter.StringMapEntryList entryList) {
	    Map<DocumentTypePolicy, String> policies = new HashMap<DocumentTypePolicy, String>();
	    if (entryList != null) {
	        for (MapStringStringAdapter.StringMapEntry entry : entryList.getEntries()) {
	            DocumentTypePolicy policy = DocumentTypePolicy.fromCode(entry.getKey());
	            // if the policy value comes back as null, that means we recieved a policy that we
	            // don't understand...ignore it
	            if (policy != null) {
	                policies.put(policy, entry.getValue());
	            }
	        }
	    }
	    return policies;
	}
	
}
