/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.api.action;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.CoreConstants;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.w3c.dom.Element;

@XmlRootElement(name = ReturnPoint.Constants.ROOT_ELEMENT_NAME)
@XmlAccessorType(XmlAccessType.NONE)
@XmlType(name = ReturnPoint.Constants.TYPE_NAME, propOrder = {
		ReturnPoint.Elements.NODE_NAME,
		CoreConstants.CommonElements.FUTURE_ELEMENTS
})
public final class ReturnPoint extends AbstractDataTransferObject {
    
	@XmlElement(name = Elements.NODE_NAME, required = true)
    private final String nodeName;
	    
    @SuppressWarnings("unused")
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private ReturnPoint() {
    	this.nodeName = null;
    }
    
    private ReturnPoint(String nodeName) {
    	if (nodeName == null) {
    		throw new IllegalArgumentException("nodeName was null");
    	}
        this.nodeName = nodeName;
    }
    
    public static ReturnPoint create(String nodeName) {
    	return new ReturnPoint(nodeName);
    }
    
    public String getNodeName() {
        return nodeName;
    }
    
    /**
     * Defines some internal constants used on this class.
     */
    static class Constants {
        final static String ROOT_ELEMENT_NAME = "returnPoint";
        final static String TYPE_NAME = "ReturnPointType";
    }
    
    /**
     * A private class which exposes constants which define the XML element names to use when this object is marshalled to XML.
     */
    static class Elements {
        final static String NODE_NAME = "nodeName";
    }

}
