/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

/**
 * Event sent to the postprocessor when document locking ids are requested.
 * 
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentLockingEvent implements IDocumentEvent {

	private static final long serialVersionUID = 1L;
	private String documentId;
	private String appDocId;

	public DocumentLockingEvent(String documentId, String appDocId) {
		this.documentId = documentId;
		this.appDocId = appDocId;
	}
	
	@Override
    public String getDocumentId() {
		return documentId;
	}

	@Override
    public String getAppDocId() {
		return appDocId;
	}
	
    @Override
    public String getDocumentEventCode() {
        return IDocumentEvent.AFTER_PROCESS;
    }

}
