/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.document.security;

/**
 * Authorization response for document routing authorization checks
 *
 * @see org.kuali.rice.kew.framework.document.security.DocumentTypeAuthorizer
 */
public final class Authorization {
    /**
     * Whether the action was authorized
     */
    private final boolean authorized;
    /**
     * Authorization or authorization failure reason
     */
    private final String reason;

    /**
     * Short-hand constructor for authorization without a reason
     * @param authorized whether the authorization check succeeded
     */
    public Authorization(boolean authorized) {
        this.authorized = authorized;
        this.reason = null;
    }

    /**
     * Construct authorization response with a reason
     * @param authorized whether the authorization check succeeded
     * @param reason reason message
     */
    public Authorization(boolean authorized, String reason) {
        this.authorized = authorized;
        this.reason = reason;
    }

    /**
     * @return whether authorization succeeded
     */
    public boolean isAuthorized() {
        return authorized;
    }

    /**
     * @return success or failure reason
     */
    public String getReason() {
        return reason;
    }
}
