/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.postprocessor;

import java.io.Serializable;



/**
 * Base event interface for events emitted from the workflow engine
 * and hooked by the {@link PostProcessor}
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface IDocumentEvent extends Serializable {
  public static final String ROUTE_LEVEL_CHANGE = "rt_lvl_change";
  public static final String ROUTE_STATUS_CHANGE = "rt_status_change";
  public static final String DELETE_CHANGE = "delete_document";
  public static final String ACTION_TAKEN = "action_taken";
  public static final String BEFORE_PROCESS = "before_process";
  public static final String AFTER_PROCESS = "after_process";
  public static final String LOCK_DOCUMENTS = "lock_documents";

  /**
   * @return the code of this document event 
   */
  public String getDocumentEventCode();

  /**
   * @return the document id for which this event was generated
   */
  public String getDocumentId();

  /**
   * @return the application document id registered for this document when it was created
   */
  public String getAppDocId();
}
