/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.framework.document.security;

import org.kuali.rice.kew.api.action.ActionType;

/**
 * Encapsulates the type of authorization check the DocumentTypeAuthorizer is making.
 * @since 2.1.3
 */
public class AuthorizableAction {
    /**
     * The authorization check type: either a document action, initiation,
     * or super user approve action request check
     */
    public static enum CheckType {
        ACTION,
        INITIATION,
        SU_APPROVE_ACTION_REQUEST
    }

    /**
     * The document ActionType if application (CheckType.ACTION)
     */
    public final ActionType actionType;
    /**
     * The CheckType
     */
    public final CheckType type;

    /**
     * Construct AuthorizableAction for a document action
     * @param actionType the document action type
     */
    public AuthorizableAction(ActionType actionType) {
        this(CheckType.ACTION, actionType);
    }

    /**
     * Construct AuthorizableAction for non-action CheckType
     * @param checkType
     */
    public AuthorizableAction(CheckType checkType) {
        this(checkType, null);
    }

    public AuthorizableAction(CheckType checkType, ActionType actionType) {
        if (checkType == null) {
            throw new IllegalArgumentException("CheckType must not be null");
        }
        // if we have specified an action check without an action type
        // or a non-action check with an action type
        // this is an illegal combination
        if ((checkType == CheckType.ACTION) == (actionType == null)) {
            throw new IllegalArgumentException("ActionType must be specified with ACTION CheckType");
        }
        this.type = checkType;
        this.actionType = actionType;
    }
}
