/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kew.impl.peopleflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.Version;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.EntityManagerImpl;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedFetchGroups;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.FetchGroupTracker;
import org.eclipse.persistence.sessions.Session;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowContract;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowDefinition;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMember;
import org.kuali.rice.kew.api.peopleflow.PeopleFlowMemberContract;
import org.kuali.rice.kew.api.repository.type.KewAttributeDefinition;
import org.kuali.rice.kew.api.repository.type.KewTypeAttribute;
import org.kuali.rice.kew.api.repository.type.KewTypeDefinition;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowAttributeBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowDelegateBo;
import org.kuali.rice.kew.impl.peopleflow.PeopleFlowMemberBo;
import org.kuali.rice.kew.impl.type.KewTypeBo;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;
import org.kuali.rice.krad.util.BeanPropertyComparator;

@Entity
@Table(name="KREW_PPL_FLW_T")
public class PeopleFlowBo
implements Serializable,
PeopleFlowContract,
MutableInactivatable,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
FetchGroupTracker,
PersistenceWeavedFetchGroups,
PersistenceWeavedRest {
    private static final long serialVersionUID = -4911187431645573793L;
    @Id
    @GeneratedValue(generator="KREW_PPL_FLW_S")
    @PortableSequenceGenerator(name="KREW_PPL_FLW_S")
    @Column(name="PPL_FLW_ID", nullable=false)
    private String id;
    @Column(name="NM", nullable=false)
    private String name;
    @Column(name="NMSPC_CD", nullable=false)
    private String namespaceCode;
    @Column(name="TYP_ID")
    private String typeId;
    @Column(name="DESC_TXT")
    private String description;
    @Column(name="ACTV", nullable=false)
    @Convert(converter=BooleanYNConverter.class)
    private boolean active = true;
    @Version
    @Column(name="VER_NBR", nullable=false)
    private Long versionNumber;
    @ManyToOne
    @JoinColumn(name="TYP_ID", insertable=false, updatable=false)
    private KewTypeBo typeBo;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="peopleFlow", orphanRemoval=true)
    private List<PeopleFlowAttributeBo> attributeBos = new ArrayList<PeopleFlowAttributeBo>();
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="peopleFlow", orphanRemoval=true)
    private List<PeopleFlowMemberBo> members = new ArrayList<PeopleFlowMemberBo>();
    @Transient
    private Map<String, String> attributeValues = new HashMap<String, String>();
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    @Transient
    @XmlTransient
    protected FetchGroup _persistence_fetchGroup;
    protected transient boolean _persistence_shouldRefreshFetchGroup;
    protected transient Session _persistence_session;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    public static PeopleFlowBo from(PeopleFlowDefinition peopleFlow, KewTypeDefinition kewTypeDefinition) {
        return PeopleFlowBo.fromAndUpdate(peopleFlow, kewTypeDefinition, null);
    }

    public static PeopleFlowBo fromAndUpdate(PeopleFlowDefinition peopleFlow, KewTypeDefinition kewTypeDefinition, PeopleFlowBo toUpdate) {
        PeopleFlowBo result = toUpdate;
        if (null == toUpdate) {
            result = new PeopleFlowBo();
        }
        result.setId(peopleFlow.getId());
        result.setName(peopleFlow.getName());
        result.setNamespaceCode(peopleFlow.getNamespaceCode());
        result.setTypeId(peopleFlow.getTypeId());
        result.setDescription(peopleFlow.getDescription());
        result.setActive(peopleFlow.isActive());
        result.setVersionNumber(peopleFlow.getVersionNumber());
        if (null == peopleFlow.getTypeId() && null != kewTypeDefinition) {
            throw new RiceIllegalArgumentException("PeopleFlow has no type id, but a KewTypeDefinition was supplied when it should not have been.");
        }
        if (null != peopleFlow.getTypeId()) {
            if (kewTypeDefinition == null) {
                throw new RiceIllegalArgumentException("PeopleFlow has a type id of '" + peopleFlow.getTypeId() + "' but no KewTypeDefinition was supplied.");
            }
            if (!kewTypeDefinition.getId().equals(peopleFlow.getTypeId())) {
                throw new RiceIllegalArgumentException("Type id of given KewTypeDefinition does not match PeopleFlow type id:  " + kewTypeDefinition.getId() + " != " + peopleFlow.getTypeId());
            }
        }
        ArrayList<PeopleFlowAttributeBo> attributesToAdd = new ArrayList<PeopleFlowAttributeBo>();
        if (null != peopleFlow.getTypeId()) {
            for (String key : peopleFlow.getAttributes().keySet()) {
                KewAttributeDefinition attributeDefinition = kewTypeDefinition.getAttributeDefinitionByName(key);
                if (null == attributeDefinition) {
                    throw new RiceIllegalArgumentException("There is no attribute definition for the given attribute name '" + key + "'");
                }
                attributesToAdd.add(PeopleFlowAttributeBo.from(attributeDefinition, null, result, (String)peopleFlow.getAttributes().get(key)));
            }
            result.setAttributeBos(attributesToAdd);
        }
        PeopleFlowBo.handleMembersUpdate(result, peopleFlow);
        return result;
    }

    private static void handleMembersUpdate(PeopleFlowBo peopleFlowBo, PeopleFlowDefinition peopleFlow) {
        HashSet<PeopleFlowMember> currentMembers = new HashSet<PeopleFlowMember>();
        if (null == peopleFlowBo.getMembers()) {
            peopleFlowBo.setMembers(new ArrayList<PeopleFlowMemberBo>());
        }
        for (PeopleFlowMemberBo pplFlwMbr : peopleFlowBo.getMembers()) {
            currentMembers.add(PeopleFlowMember.Builder.create((PeopleFlowMemberContract)pplFlwMbr).build());
        }
        if (!currentMembers.equals(new HashSet(peopleFlow.getMembers()))) {
            ArrayList<PeopleFlowMemberBo> membersToAdd = new ArrayList<PeopleFlowMemberBo>();
            for (PeopleFlowMember member : peopleFlow.getMembers()) {
                membersToAdd.add(PeopleFlowMemberBo.from(member, peopleFlowBo));
            }
            peopleFlowBo.setMembers(membersToAdd);
        }
    }

    public static PeopleFlowDefinition maintenanceCopy(PeopleFlowBo peopleFlowBo) {
        if (null == peopleFlowBo) {
            return null;
        }
        PeopleFlowDefinition.Builder builder = PeopleFlowDefinition.Builder.createMaintenanceCopy((PeopleFlowContract)peopleFlowBo);
        return builder.build();
    }

    public static PeopleFlowDefinition to(PeopleFlowBo peopleFlowBo) {
        if (null == peopleFlowBo) {
            return null;
        }
        PeopleFlowDefinition.Builder builder = PeopleFlowDefinition.Builder.create((PeopleFlowContract)peopleFlowBo);
        return builder.build();
    }

    public PeopleFlowBo() {
    }

    public PeopleFlowBo(PeopleFlowDefinition pfDef) {
        PeopleFlowBo newPFBo = new PeopleFlowBo();
        this.id = pfDef.getId();
        this.active = pfDef.isActive();
        this.name = pfDef.getName();
        this.namespaceCode = pfDef.getNamespaceCode();
        this.typeId = pfDef.getTypeId();
        this.description = pfDef.getDescription();
        this.versionNumber = pfDef.getVersionNumber();
    }

    public void rebuildTypeAttributes() {
        this._persistence_set_attributeBos(new ArrayList());
        this.attributeValues = new HashMap<String, String>();
        KewTypeDefinition typeDefinition = KewApiServiceLocator.getKewTypeRepositoryService().getTypeById(this._persistence_get_typeId());
        if (typeDefinition.getAttributes() != null && !typeDefinition.getAttributes().isEmpty()) {
            ArrayList typeAttributes = new ArrayList(typeDefinition.getAttributes());
            ArrayList<String> sortAttributes = new ArrayList<String>();
            sortAttributes.add("sequenceNumber");
            Collections.sort(typeAttributes, new BeanPropertyComparator(sortAttributes));
            for (KewTypeAttribute typeAttribute : typeAttributes) {
                PeopleFlowAttributeBo attributeBo = PeopleFlowAttributeBo.from(typeAttribute.getAttributeDefinition(), null, this, null);
                this._persistence_get_attributeBos().add(attributeBo);
                this.attributeValues.put(typeAttribute.getAttributeDefinition().getName(), "");
            }
        }
    }

    public void updateAttributeBoValues() {
        for (PeopleFlowAttributeBo attributeBo : this._persistence_get_attributeBos()) {
            if (!this.attributeValues.containsKey(attributeBo.getAttributeDefinition().getName())) continue;
            String attributeValue = this.attributeValues.get(attributeBo.getAttributeDefinition().getName());
            attributeBo.setValue(attributeValue);
        }
    }

    @PostLoad
    protected void postLoad() {
        this.attributeValues = new HashMap<String, String>();
        for (PeopleFlowAttributeBo attributeBo : this._persistence_get_attributeBos()) {
            this.attributeValues.put(attributeBo.getAttributeDefinition().getName(), attributeBo.getValue());
        }
        for (PeopleFlowMemberBo member : this._persistence_get_members()) {
            if (member.getMemberName() == null) {
                member.updateRelatedObject();
            }
            for (PeopleFlowDelegateBo delegate : member.getDelegates()) {
                if (delegate.getMemberName() != null) continue;
                delegate.updateRelatedObject();
            }
        }
    }

    public String getId() {
        return this._persistence_get_id();
    }

    public void setId(String id) {
        this._persistence_set_id(id);
    }

    public String getName() {
        return this._persistence_get_name();
    }

    public void setName(String name) {
        this._persistence_set_name(name);
    }

    public String getNamespaceCode() {
        return this._persistence_get_namespaceCode();
    }

    public void setNamespaceCode(String namespaceCode) {
        this._persistence_set_namespaceCode(namespaceCode);
    }

    public String getTypeId() {
        return this._persistence_get_typeId();
    }

    public void setTypeId(String typeId) {
        this._persistence_set_typeId(typeId);
    }

    public String getDescription() {
        return this._persistence_get_description();
    }

    public void setDescription(String description) {
        this._persistence_set_description(description);
    }

    public boolean isActive() {
        return this._persistence_get_active();
    }

    public void setActive(boolean active) {
        this._persistence_set_active(active);
    }

    public Long getVersionNumber() {
        return this._persistence_get_versionNumber();
    }

    public void setVersionNumber(Long versionNumber) {
        this._persistence_set_versionNumber(versionNumber);
    }

    public List<PeopleFlowAttributeBo> getAttributeBos() {
        return this._persistence_get_attributeBos();
    }

    public Map<String, String> getAttributes() {
        HashMap<String, String> results = new HashMap<String, String>();
        if (null != this._persistence_get_attributeBos()) {
            for (PeopleFlowAttributeBo attr : this._persistence_get_attributeBos()) {
                results.put(attr.getAttributeDefinition().getName(), attr.getValue());
            }
        }
        return results;
    }

    public void setAttributeBos(List<PeopleFlowAttributeBo> attributeBos) {
        this._persistence_set_attributeBos(attributeBos);
    }

    public List<PeopleFlowMemberBo> getMembers() {
        return this._persistence_get_members();
    }

    public void setMembers(List<PeopleFlowMemberBo> members) {
        this._persistence_set_members(members);
    }

    public Map<String, String> getAttributeValues() {
        return this.attributeValues;
    }

    public void setAttributeValues(Map<String, String> attributeValues) {
        this.attributeValues = attributeValues;
    }

    public KewTypeBo getTypeBo() {
        return this._persistence_get_typeBo();
    }

    public void setTypeBo(KewTypeBo typeBo) {
        this._persistence_set_typeBo(typeBo);
    }

    public Object _persistence_post_clone() {
        this._persistence_fetchGroup = null;
        this._persistence_session = null;
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new PeopleFlowBo();
    }

    public Object _persistence_get(String string) {
        if (string == "attributeBos") {
            return this.attributeBos;
        }
        if (string == "members") {
            return this.members;
        }
        if (string == "name") {
            return this.name;
        }
        if (string == "typeBo") {
            return this.typeBo;
        }
        if (string == "description") {
            return this.description;
        }
        if (string == "active") {
            return this.active;
        }
        if (string == "typeId") {
            return this.typeId;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "namespaceCode") {
            return this.namespaceCode;
        }
        if (string == "versionNumber") {
            return this.versionNumber;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "attributeBos") {
            this.attributeBos = (List)object;
            return;
        }
        if (string == "members") {
            this.members = (List)object;
            return;
        }
        if (string == "name") {
            this.name = (String)object;
            return;
        }
        if (string == "typeBo") {
            this.typeBo = (KewTypeBo)object;
            return;
        }
        if (string == "description") {
            this.description = (String)object;
            return;
        }
        if (string == "active") {
            this.active = (Boolean)object;
            return;
        }
        if (string == "typeId") {
            this.typeId = (String)object;
            return;
        }
        if (string == "id") {
            this.id = (String)object;
            return;
        }
        if (string == "namespaceCode") {
            this.namespaceCode = (String)object;
            return;
        }
        if (string == "versionNumber") {
            this.versionNumber = (Long)object;
            return;
        }
    }

    public List _persistence_get_attributeBos() {
        this._persistence_checkFetched("attributeBos");
        return this.attributeBos;
    }

    public void _persistence_set_attributeBos(List list) {
        this._persistence_checkFetchedForSet("attributeBos");
        this.attributeBos = list;
    }

    public List _persistence_get_members() {
        this._persistence_checkFetched("members");
        return this.members;
    }

    public void _persistence_set_members(List list) {
        this._persistence_checkFetchedForSet("members");
        this.members = list;
    }

    public String _persistence_get_name() {
        this._persistence_checkFetched("name");
        return this.name;
    }

    public void _persistence_set_name(String string) {
        this._persistence_checkFetchedForSet("name");
        this.name = string;
    }

    public KewTypeBo _persistence_get_typeBo() {
        this._persistence_checkFetched("typeBo");
        return this.typeBo;
    }

    public void _persistence_set_typeBo(KewTypeBo kewTypeBo) {
        this._persistence_checkFetchedForSet("typeBo");
        this.typeBo = kewTypeBo;
    }

    public String _persistence_get_description() {
        this._persistence_checkFetched("description");
        return this.description;
    }

    public void _persistence_set_description(String string) {
        this._persistence_checkFetchedForSet("description");
        this.description = string;
    }

    public boolean _persistence_get_active() {
        this._persistence_checkFetched("active");
        return this.active;
    }

    public void _persistence_set_active(boolean bl) {
        this._persistence_checkFetchedForSet("active");
        this.active = bl;
    }

    public String _persistence_get_typeId() {
        this._persistence_checkFetched("typeId");
        return this.typeId;
    }

    public void _persistence_set_typeId(String string) {
        this._persistence_checkFetchedForSet("typeId");
        this.typeId = string;
    }

    public String _persistence_get_id() {
        this._persistence_checkFetched("id");
        return this.id;
    }

    public void _persistence_set_id(String string) {
        this._persistence_checkFetchedForSet("id");
        this.id = string;
    }

    public String _persistence_get_namespaceCode() {
        this._persistence_checkFetched("namespaceCode");
        return this.namespaceCode;
    }

    public void _persistence_set_namespaceCode(String string) {
        this._persistence_checkFetchedForSet("namespaceCode");
        this.namespaceCode = string;
    }

    public Long _persistence_get_versionNumber() {
        this._persistence_checkFetched("versionNumber");
        return this.versionNumber;
    }

    public void _persistence_set_versionNumber(Long l) {
        this._persistence_checkFetchedForSet("versionNumber");
        this.versionNumber = l;
    }

    public Session _persistence_getSession() {
        return this._persistence_session;
    }

    public void _persistence_setSession(Session session) {
        this._persistence_session = session;
    }

    public FetchGroup _persistence_getFetchGroup() {
        return this._persistence_fetchGroup;
    }

    public void _persistence_setFetchGroup(FetchGroup fetchGroup) {
        this._persistence_fetchGroup = fetchGroup;
    }

    public boolean _persistence_shouldRefreshFetchGroup() {
        return this._persistence_shouldRefreshFetchGroup;
    }

    public void _persistence_setShouldRefreshFetchGroup(boolean bl) {
        this._persistence_shouldRefreshFetchGroup = bl;
    }

    public void _persistence_resetFetchGroup() {
    }

    public boolean _persistence_isAttributeFetched(String string) {
        return this._persistence_fetchGroup == null || this._persistence_fetchGroup.containsAttributeInternal(string);
    }

    public void _persistence_checkFetched(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttribute((FetchGroupTracker)this, (String)string);
        }
    }

    public void _persistence_checkFetchedForSet(String string) {
        if (!this._persistence_isAttributeFetched(string)) {
            EntityManagerImpl.processUnfetchedAttributeForSet((FetchGroupTracker)this, (String)string);
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

