/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kew.impl.peopleflow;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.util.RiceKeyConstants;
import org.kuali.rice.kew.impl.KewImplConstants;
import org.kuali.rice.krad.maintenance.MaintenanceDocument;
import org.kuali.rice.krad.rules.MaintenanceDocumentRuleBase;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PeopleFlowBusRule extends MaintenanceDocumentRuleBase {

    @Override
    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        boolean result = super.processCustomSaveDocumentBusinessRules(document);
        PeopleFlowBo peopleFlowDoc = (PeopleFlowBo)document.getNewMaintainableObject().getDataObject();
        if (StringUtils.isBlank(peopleFlowDoc.getId())) {
            result &= checkIfDuplicatePeopleFlow(peopleFlowDoc);
        }
        return result;
    }

    protected boolean checkIfDuplicatePeopleFlow(PeopleFlowBo peopleFlowBo){
        boolean rulePassed = true;
        if (!(StringUtils.isBlank(peopleFlowBo.getName()) ||
              StringUtils.isBlank(peopleFlowBo.getNamespaceCode()))) {
                Map<String,String> criteria = new HashMap<String,String>();
                criteria.put(KewImplConstants.PropertyConstants.NAMESPACE_CODE, peopleFlowBo.getNamespaceCode());
                criteria.put(KewImplConstants.PropertyConstants.NAME, peopleFlowBo.getName());
                Collection<PeopleFlowBo> peopleFlows = KRADServiceLocatorWeb.getLegacyDataAdapter().findMatching(PeopleFlowBo.class, criteria);
                if (CollectionUtils.isEmpty(peopleFlows)) {
                    rulePassed = true;
                } else {
                    GlobalVariables.getMessageMap().putError("document.peopleFlow.duplicate",
                            RiceKeyConstants.PEOPLEFLOW_DUPLICATE, peopleFlowBo.getName().toString(), peopleFlowBo.getNamespaceCode().toString());
                    rulePassed = false;
                }
        }
        return rulePassed;
    }
}
