/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.residency;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;

/**
 * residency info for a KIM identity
 * 
 * @author Kuali Rice Team (kuali-rice@googlegroups.com)
 *
 */
public interface EntityResidencyContract extends Versioned, GloballyUnique, Identifiable {

	
	/**
     * Gets this {@link EntityResidencyContract}'s identity id.
     * @return the identity id for this {@link EntityResidencyContract}, or null if none has been assigned.
     */
	String getEntityId();
	
	/**
     * Gets this {@link EntityResidencyContract}'s determination method.
     * @return the determination method for this {@link EntityResidencyContract}, or null if none has been assigned.
     */
	String getDeterminationMethod();
	
	/**
     * Gets the state this {@link EntityResidencyContract} is in.
     * @return the state this {@link EntityResidencyContract} is in, or null if none has been assigned.
     */
	String getInState();
}
