/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.role;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * This is the contract for a KimPermission.  
 *  
 */
public interface RolePermissionContract extends Versioned, GloballyUnique, Identifiable, Inactivatable {
    
    /**
     * The Role ID referenced by the Role Permission.
     * 
     * @return roleId
     */
	String getRoleId();  
	
    /**
     * The Permission ID referenced by the Role Permission.
     * 
     * @return permissionId
     */
	String getPermissionId();
}
