/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.services;

import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.group.GroupService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.permission.PermissionService;
import org.kuali.rice.kim.api.responsibility.ResponsibilityService;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.kim.api.type.KimTypeInfoService;

public class KimApiServiceLocator {

    public static final String KIM_GROUP_SERVICE = "kimGroupService";
    public static final String KIM_IDENTITY_SERVICE = "kimIdentityService";
    public static final String KIM_PERMISSION_SERVICE = "kimPermissionService";
    public static final String KIM_RESPONSIBILITY_SERVICE = "kimResponsibilityService";
    public static final String KIM_ROLE_SERVICE = "kimRoleService";
    public static final String KIM_PERSON_SERVICE = "personService";
    public static final String KIM_TYPE_INFO_SERVICE = "kimTypeInfoService";

    static <T> T getService(String serviceName) {
        return GlobalResourceLoader.<T>getService(serviceName);
    }

    public static KimTypeInfoService getKimTypeInfoService() {
        return getService(KIM_TYPE_INFO_SERVICE);
    }

    public static PersonService getPersonService() {
        return getService(KIM_PERSON_SERVICE);
    }

    public static RoleService getRoleService() {
        return getService(KIM_ROLE_SERVICE);
    }
    
    public static GroupService getGroupService() {
    	return getService(KIM_GROUP_SERVICE);
    }
    
    public static IdentityService getIdentityService() {
    	return getService(KIM_IDENTITY_SERVICE);
    }
    public static PermissionService getPermissionService() {
    	return getService(KIM_PERMISSION_SERVICE);
    }
    public static ResponsibilityService getResponsibilityService() {
    	return getService(KIM_RESPONSIBILITY_SERVICE);
    }
    
}
