/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.history;

import java.sql.Timestamp;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.OrderByField;
import org.kuali.rice.core.api.criteria.OrderDirection;
import org.kuali.rice.core.api.criteria.Predicate;
import org.kuali.rice.core.api.criteria.PredicateFactory;
import org.kuali.rice.core.api.criteria.QueryByCriteria;

public final class HistoryQueryUtils {
    private HistoryQueryUtils() {
        throw new UnsupportedOperationException();
    }

    public static QueryByCriteria historyQuery(String id, DateTime asOfDate) {
        Timestamp asOfTimestamp = new Timestamp(asOfDate.getMillis());
        Predicate predicate = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"id", (Object)id), PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"activeFromDateValue"), PredicateFactory.lessThanOrEqual((String)"activeFromDateValue", (Object)asOfTimestamp)}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"activeToDateValue"), PredicateFactory.greaterThan((String)"activeToDateValue", (Object)asOfTimestamp)})})});
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setMaxResults(Integer.valueOf(1));
        criteria.setPredicates(new Predicate[]{predicate});
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)"activeFromDateValue", (OrderDirection)OrderDirection.DESCENDING).build());
        orderByFields.add(OrderByField.Builder.create((String)"historyId", (OrderDirection)OrderDirection.DESCENDING).build());
        criteria.setOrderByFields(orderByFields);
        return criteria.build();
    }

    public static QueryByCriteria futureRecordQuery(String id, DateTime asOfDate) {
        Timestamp asOfTimestamp = new Timestamp(asOfDate.getMillis());
        Predicate predicate = PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.equal((String)"id", (Object)id), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)"activeFromDateValue"), PredicateFactory.greaterThan((String)"activeFromDateValue", (Object)asOfTimestamp)})});
        QueryByCriteria.Builder criteria = QueryByCriteria.Builder.create();
        criteria.setMaxResults(Integer.valueOf(1));
        criteria.setPredicates(new Predicate[]{predicate});
        ArrayList<OrderByField> orderByFields = new ArrayList<OrderByField>();
        orderByFields.add(OrderByField.Builder.create((String)"activeFromDateValue", (OrderDirection)OrderDirection.DESCENDING).build());
        orderByFields.add(OrderByField.Builder.create((String)"historyId", (OrderDirection)OrderDirection.DESCENDING).build());
        criteria.setOrderByFields(orderByFields);
        return criteria.build();
    }

    public static Predicate between(String startField, String endField, DateTime asOfDate) {
        asOfDate = asOfDate.secondOfDay().roundCeilingCopy();
        return PredicateFactory.and((Predicate[])new Predicate[]{PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)startField), PredicateFactory.lessThanOrEqual((String)startField, (Object)asOfDate.toDate())}), PredicateFactory.or((Predicate[])new Predicate[]{PredicateFactory.isNull((String)endField), PredicateFactory.greaterThan((String)endField, (Object)asOfDate.toDate())})});
    }
}

