/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.permission;


import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
import org.kuali.rice.kim.api.common.template.TemplateContract;

import java.util.Map;

/**
 * This is the contract for a Permission. Represents a single permission within the system.
 * 
 * Permissions are attached to roles. All authorization checks should be done against permissions,
 * never against roles or groups.
 *  
 */
public interface PermissionContract extends Versioned, GloballyUnique, Inactivatable, Identifiable {
    
    /**
     * The namespace code that this Permission belongs too.
     *
     * @return namespaceCode
     */
    String getNamespaceCode();
    
    /**
     * The name of the Permission.
     *
     * @return name
     */
    String getName();
    
    /**
     * The description of the Permission.
     *
     * @return description
     */
	String getDescription();

    /**
     * The Template referenced by the Permission.
     *
     * @return templateId
     */
	TemplateContract getTemplate();
	
   /** 
	 * Attributes for a Permission.
	 * 
	 * @return attributes
	 */
    Map<String, String> getAttributes();
}
