/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.common.attribute;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.kim.api.type.KimTypeContract;

/**
 * This is the contract for a KimDataAttribute.  A KimDataAttribute
 * associates a value with a kim attribute.
 */
public interface KimAttributeDataContract extends Identifiable, Versioned, GloballyUnique {

    /**
     * The id of the object this AttributeData is associated with.  For
     * example:  this could be a permissionId, roleId, groupId, or
     * responsibilityId.
     *
     * @return the id
     */
    String getAssignedToId();

    /**
     * The attribute value.  This can be null or blank.
     *
     * @return the attribute value.
     */
	String getAttributeValue();

    /**
     * The kim attribute associated with the kim attribute data.  This can be null if no KimAttributes are associated.
     *
     * @return the kim attribute
     */
	KimAttributeContract getKimAttribute();


    /**
     * The kim type id associated with the kim attribute data.  This can be null if no kim types are associated.
     *
     * @return the kim type id
     */
    String getKimTypeId();

    /**
     * The kim type associated with the kim attribute data.  This can be null if no kim types are associated.
     *
     * @return the kim type
     */
    KimTypeContract getKimType();
}
