/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.identity.privacy;


import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Versioned;
 /**
  * This is a contract for EntityPrivacyPreferences. Privacy preferences are used to
  * hide/suppress certain contact information.
  *
  * @author Kuali Rice Team (rice.collab@kuali.org)
  */
public interface EntityPrivacyPreferencesContract extends Versioned, GloballyUnique {

    /**
     * Gets this id of the parent identity object.
     * @return the identity id for this {@link EntityPrivacyPreferencesContract}
     */
    String getEntityId();

    /**
     * This is value designating if Entity Name should be suppressed.
     *
     * <p>
     * This is a boolean value that shows if identity names should be suppressed or not.
     * </p>
     *
     * @return suppressName
     */
    boolean isSuppressName();

    /**
     * This is value designating if Entity Address should be suppressed.
     *
     * <p>
     * This is a boolean value that shows if identity addresses should be suppressed or not.
     * </p>
     *
     * @return suppressAddress
     */
	boolean isSuppressAddress();

    /**
     * This is value designating if Entity Email should be suppressed.
     *
     * <p>
     * This is a boolean value that shows if identity emails should be suppressed or not.
     * </p>
     *
     * @return suppressEmail
     */
	boolean isSuppressEmail();

    /**
     * This is value designating if Entity Phone should be suppressed.
     *
     * <p>
     * This is a boolean value that shows if identity phones should be suppressed or not.
     * </p>
     *
     * @return suppressPhone
     */
	boolean isSuppressPhone();

    /**
     * This is value designating if Entity Personal information should be suppressed.
     *
     * <p>
     * This is a boolean value that shows if identity personal information should be suppressed or not.
     * </p>
     *
     * @return suppressPersonal
     */
	boolean isSuppressPersonal();
}
