/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.permission;

import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.exception.RiceIllegalStateException;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.common.assignee.Assignee;
import org.kuali.rice.kim.api.common.template.Template;
import org.kuali.rice.kim.api.common.template.TemplateQueryResults;
import org.kuali.rice.kim.api.permission.Permission;
import org.kuali.rice.kim.api.permission.PermissionQueryResults;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="permissionService", targetNamespace="http://rice.kuali.org/kim/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface PermissionService {
    @WebMethod(operationName="createPermission")
    @WebResult(name="permission")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/TemplateType{Permission}"}, allEntries=true)
    public Permission createPermission(@WebParam(name="permission") Permission var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="updatePermission")
    @WebResult(name="permission")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/PermissionType", "http://rice.kuali.org/kim/v2_0/TemplateType{Permission}"}, allEntries=true)
    public Permission updatePermission(@WebParam(name="permission") Permission var1) throws RiceIllegalArgumentException, RiceIllegalStateException;

    @WebMethod(operationName="hasPermission")
    @WebResult(name="hasPermission")
    public boolean hasPermission(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionName") String var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isAuthorized")
    @WebResult(name="isAuthorized")
    public boolean isAuthorized(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionName") String var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="hasPermissionByTemplate")
    @WebResult(name="hasPermission")
    public boolean hasPermissionByTemplate(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionTemplateName") String var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="permissionDetails") Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isAuthorizedByTemplate")
    @WebResult(name="isAuthorized")
    public boolean isAuthorizedByTemplate(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionTemplateName") String var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="permissionDetails") Map<String, String> var4, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var5) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPermissionAssignees")
    @XmlElementWrapper(name="assignees", required=true)
    @XmlElement(name="assignee", required=false)
    @WebResult(name="assignees")
    public List<Assignee> getPermissionAssignees(@WebParam(name="namespaceCode") String var1, @WebParam(name="permissionName") String var2, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPermissionAssigneesByTemplate")
    @XmlElementWrapper(name="assignees", required=true)
    @XmlElement(name="assignee", required=false)
    @WebResult(name="assignees")
    public List<Assignee> getPermissionAssigneesByTemplate(@WebParam(name="namespaceCode") String var1, @WebParam(name="permissionTemplateName") String var2, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="permissionDetails") Map<String, String> var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isPermissionDefined")
    @WebResult(name="isPermissionDefined")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'{isPermissionDefined}' + 'namespaceCode=' + #p0 + '|' + 'permissionName=' + #p1")
    public boolean isPermissionDefined(@WebParam(name="namespaceCode") String var1, @WebParam(name="permissionName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isPermissionDefinedByTemplate")
    @WebResult(name="isPermissionDefinedByTemplate")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'{isPermissionDefinedByTemplate}' + 'namespaceCode=' + #p0 + '|' + 'permissionTemplateName=' + #p1 + '|' + 'permissionDetails=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).mapKey(#p2)")
    public boolean isPermissionDefinedByTemplate(@WebParam(name="namespaceCode") String var1, @WebParam(name="permissionTemplateName") String var2, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="permissionDetails") Map<String, String> var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAuthorizedPermissions")
    @XmlElementWrapper(name="permissions", required=true)
    @XmlElement(name="permission", required=false)
    @WebResult(name="permissions")
    public List<Permission> getAuthorizedPermissions(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionName") String var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var4) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAuthorizedPermissionsByTemplate")
    @XmlElementWrapper(name="permissions", required=true)
    @XmlElement(name="permission", required=false)
    @WebResult(name="permissions")
    public List<Permission> getAuthorizedPermissionsByTemplate(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2, @WebParam(name="permissionTemplateName") String var3, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="permissionDetails") Map<String, String> var4, @XmlJavaTypeAdapter(value=MapStringStringAdapter.class) @WebParam(name="qualification") Map<String, String> var5) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPermission")
    @WebResult(name="permission")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'id=' + #p0")
    public Permission getPermission(@WebParam(name="id") String var1);

    @WebMethod(operationName="findPermByNamespaceCodeAndName")
    @WebResult(name="permission")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public Permission findPermByNamespaceCodeAndName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findPermissionsByTemplate")
    @XmlElementWrapper(name="permissions", required=true)
    @XmlElement(name="permission", required=false)
    @WebResult(name="permissions")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'namespaceCode=' + #p1 + '|' + 'templateName=' + #p2")
    public List<Permission> findPermissionsByTemplate(@WebParam(name="namespaceCode") String var1, @WebParam(name="templateName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getPermissionTemplate")
    @WebResult(name="id")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/TemplateType{Permission}"}, key="'id=' + #p0")
    public Template getPermissionTemplate(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findPermTemplateByNamespaceCodeAndName")
    @WebResult(name="permissionTemplate")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/TemplateType{Permission}"}, key="'namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public Template findPermTemplateByNamespaceCodeAndName(@WebParam(name="namespaceCode") String var1, @WebParam(name="name") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAllTemplates")
    @XmlElementWrapper(name="templates", required=true)
    @XmlElement(name="template", required=false)
    @WebResult(name="templates")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/TemplateType{Permission}"}, key="'all'")
    public List<Template> getAllTemplates();

    @WebMethod(operationName="getRoleIdsForPermission")
    @XmlElementWrapper(name="roleIds", required=true)
    @XmlElement(name="roleId", required=false)
    @WebResult(name="roleIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/PermissionType"}, key="'{RoleIds}namespaceCode=' + #p0 + '|' + 'name=' + #p1")
    public List<String> getRoleIdsForPermission(@WebParam(name="namespaceCode") String var1, @WebParam(name="permissionName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findPermissions")
    @WebResult(name="results")
    public PermissionQueryResults findPermissions(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findPermissionTemplates")
    @WebResult(name="results")
    public TemplateQueryResults findPermissionTemplates(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;
}

