/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.group;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.joda.time.DateTime;
import org.kuali.rice.core.api.criteria.QueryByCriteria;
import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.util.jaxb.DateTimeAdapter;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.group.Group;
import org.kuali.rice.kim.api.group.GroupMember;
import org.kuali.rice.kim.api.group.GroupMemberQueryResults;
import org.kuali.rice.kim.api.group.GroupQueryResults;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;

@WebService(name="groupService", targetNamespace="http://rice.kuali.org/kim/v2_0")
@SOAPBinding(style=SOAPBinding.Style.DOCUMENT, use=SOAPBinding.Use.LITERAL, parameterStyle=SOAPBinding.ParameterStyle.WRAPPED)
public interface GroupService {
    @WebMethod(operationName="getGroupsByPrincipalId")
    @XmlElementWrapper(name="groups", required=true)
    @XmlElement(name="group", required=false)
    @WebResult(name="groups")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'principalId=' + #p0")
    public List<Group> getGroupsByPrincipalId(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroupsByPrincipalIdAndNamespaceCode")
    @XmlElementWrapper(name="groups", required=true)
    @XmlElement(name="group", required=false)
    @WebResult(name="groups")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'principalId=' + #p0 + '|' + 'namespaceCode=' + #p1")
    public List<Group> getGroupsByPrincipalIdAndNamespaceCode(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findGroupIds")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    public List<String> findGroupIds(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findGroups")
    @WebResult(name="results")
    public GroupQueryResults findGroups(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="findGroupMembers")
    @WebResult(name="results")
    public GroupMemberQueryResults findGroupMembers(@WebParam(name="query") QueryByCriteria var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroup")
    @WebResult(name="group")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupType"}, key="'id=' + #p0")
    public Group getGroup(@WebParam(name="id") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroupByNamespaceCodeAndName")
    @WebResult(name="group")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupType"}, key="'namespaceCode=' + #p0 + '|' + 'groupName=' + #p1")
    public Group getGroupByNamespaceCodeAndName(@WebParam(name="namespaceCode") String var1, @WebParam(name="groupName") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroups")
    @XmlElementWrapper(name="groups", required=true)
    @XmlElement(name="group", required=false)
    @WebResult(name="groups")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupType"}, key="'ids=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<Group> getGroups(@WebParam(name="ids") Collection<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isMemberOfGroup")
    @WebResult(name="isMember")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{isMemberOfGroup}' + 'principalId=' + #p0 + '|' + 'groupId=' + #p1")
    public boolean isMemberOfGroup(@WebParam(name="principalId") String var1, @WebParam(name="groupId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isDirectMemberOfGroup")
    @WebResult(name="isDirectMember")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{isDirectMemberOfGroup}' + 'principalId=' + #p0 + '|' + 'groupId=' + #p1")
    public boolean isDirectMemberOfGroup(@WebParam(name="principalId") String var1, @WebParam(name="groupId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroupIdsByPrincipalId")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getGroupIdsByPrincipalId}' + 'principalId=' + #p0")
    public List<String> getGroupIdsByPrincipalId(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getGroupIdsByPrincipalIdAndNamespaceCode")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getGroupIdsByPrincipalIdAndNamespaceCode}' + 'principalId=' + #p0 + '|' + 'namespaceCode=' + #p1")
    public List<String> getGroupIdsByPrincipalIdAndNamespaceCode(@WebParam(name="principalId") String var1, @WebParam(name="namespaceCode") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectGroupIdsByPrincipalId")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getDirectGroupIdsByPrincipalId}' + 'principalId=' + #p0")
    public List<String> getDirectGroupIdsByPrincipalId(@WebParam(name="principalId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isGroupMemberOfGroup")
    @WebResult(name="isMember")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{isGroupMemberOfGroup}' + 'groupMemberId=' + #p0 + '|' + 'groupId=' + #p1")
    public boolean isGroupMemberOfGroup(@WebParam(name="groupMemberId") String var1, @WebParam(name="groupId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMemberPrincipalIds")
    @XmlElementWrapper(name="principalIds", required=true)
    @XmlElement(name="principalId", required=false)
    @WebResult(name="principalIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getMemberPrincipalIds}' + 'groupId=' + #p0")
    public List<String> getMemberPrincipalIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectMemberPrincipalIds")
    @XmlElementWrapper(name="principalIds", required=true)
    @XmlElement(name="principalId", required=false)
    @WebResult(name="principalIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getDirectMemberPrincipalIds}' + 'groupId=' + #p0")
    public List<String> getDirectMemberPrincipalIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMemberGroupIds")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getMemberGroupIds}' + 'groupId=' + #p0")
    public List<String> getMemberGroupIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectMemberOfGroup")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getDirectMemberGroupIds}' + 'groupId=' + #p0")
    public List<String> getDirectMemberGroupIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getParentGroupIds")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getParentGroupIds}' + 'groupId=' + #p0")
    public List<String> getParentGroupIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectParentGroupIds")
    @XmlElementWrapper(name="groupIds", required=true)
    @XmlElement(name="groupId", required=false)
    @WebResult(name="groupIds")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'{getDirectParentGroupIds}' + 'groupId=' + #p0")
    public List<String> getDirectParentGroupIds(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getAttributes")
    @WebResult(name="attributes")
    @XmlJavaTypeAdapter(value=MapStringStringAdapter.class)
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupType"}, key="'{getAttributes}' + 'groupId=' + #p0")
    public Map<String, String> getAttributes(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMembersOfGroup")
    @XmlElementWrapper(name="members", required=true)
    @XmlElement(name="member", required=false)
    @WebResult(name="members")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'groupId=' + #p0")
    public List<GroupMember> getMembersOfGroup(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMembersOfGroupWithDate")
    @XmlElementWrapper(name="members", required=true)
    @XmlElement(name="member", required=false)
    @WebResult(name="members")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'groupId=' + #p0 + '|' + 'asOfDate=' + #p1")
    public List<GroupMember> getMembersOfGroupWithDate(@WebParam(name="groupId") String var1, @XmlJavaTypeAdapter(value=DateTimeAdapter.class) @WebParam(name="asOfDate") DateTime var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMembers")
    @XmlElementWrapper(name="members", required=true)
    @XmlElement(name="member", required=false)
    @WebResult(name="members")
    @Cacheable(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType"}, key="'groupIds=' + T(org.kuali.rice.core.api.cache.CacheKeyUtils).key(#p0)")
    public List<GroupMember> getMembers(@WebParam(name="groupIds") List<String> var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createGroup")
    @WebResult(name="group")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupType", "http://rice.kuali.org/kim/v2_0/GroupMemberType"}, allEntries=true)
    public Group createGroup(@WebParam(name="group") Group var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateGroup")
    @WebResult(name="group")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupType", "http://rice.kuali.org/kim/v2_0/GroupMemberType"}, allEntries=true)
    public Group updateGroup(@WebParam(name="group") Group var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateGroupWithId")
    @WebResult(name="group")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupType", "http://rice.kuali.org/kim/v2_0/GroupMemberType"}, allEntries=true)
    public Group updateGroup(@WebParam(name="groupId") String var1, @WebParam(name="group") Group var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="createGroupMember")
    @WebResult(name="groupMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public GroupMember createGroupMember(@WebParam(name="groupMember") GroupMember var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="updateGroupMember")
    @WebResult(name="groupMember")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public GroupMember updateGroupMember(@WebParam(name="groupMember") GroupMember var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="addGroupToGroup")
    @WebResult(name="addedToGroup")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public boolean addGroupToGroup(@WebParam(name="childId") String var1, @WebParam(name="parentId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="removeGroupFromGroup")
    @WebResult(name="removedFromGroup")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public boolean removeGroupFromGroup(@WebParam(name="childId") String var1, @WebParam(name="parentId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="addPrincipalToGroup")
    @WebResult(name="addedToGroup")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public boolean addPrincipalToGroup(@WebParam(name="principalId") String var1, @WebParam(name="groupId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="removePrincipalFromGroup")
    @WebResult(name="removedFromGroup")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public boolean removePrincipalFromGroup(@WebParam(name="principalId") String var1, @WebParam(name="groupId") String var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="removeAllMembers")
    @CacheEvict(value={"http://rice.kuali.org/kim/v2_0/GroupMemberType", "http://rice.kuali.org/kim/v2_0/RoleType"}, allEntries=true)
    public void removeAllMembers(@WebParam(name="groupId") String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isGroupMemberOfGroupWithDate")
    @WebResult(name="isMember")
    public boolean isGroupMemberOfGroupWithDate(String var1, String var2, @XmlJavaTypeAdapter(value=DateTimeAdapter.class) @WebParam(name="asOfDate") DateTime var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="isMemberOfGroupWithDate")
    @WebResult(name="isMember")
    public boolean isMemberOfGroupWithDate(String var1, String var2, @XmlJavaTypeAdapter(value=DateTimeAdapter.class) @WebParam(name="asOfDate") DateTime var3) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectMemberGroupIdsWithDate")
    @XmlElementWrapper(name="directMembers", required=true)
    @XmlElement(name="directMember", required=false)
    @WebResult(name="directMembers")
    public List<String> getDirectMemberGroupIdsWithDate(String var1) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getDirectParentGroupIdsWithDate")
    @XmlElementWrapper(name="directParents", required=true)
    @XmlElement(name="directParent", required=false)
    @WebResult(name="directParents")
    public List<String> getDirectParentGroupIdsWithDate(String var1, @XmlJavaTypeAdapter(value=DateTimeAdapter.class) @WebParam(name="asOfDate") DateTime var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getMembersWithDate")
    @XmlElementWrapper(name="members", required=true)
    @XmlElement(name="member", required=false)
    @WebResult(name="members")
    public List<GroupMember> getMembersWithDate(List<String> var1, @XmlJavaTypeAdapter(value=DateTimeAdapter.class) @WebParam(name="asOfDate") DateTime var2) throws RiceIllegalArgumentException;

    @WebMethod(operationName="getCurrentAndFutureMembers")
    public List<GroupMember> getCurrentAndFutureMembers(@WebParam(name="groupId") String var1);
}

