/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.common.attribute;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.common.attribute.KimAttributeContract;
import org.w3c.dom.Element;

@XmlRootElement(name="kimAttribute")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KimAttributeType", propOrder={"id", "componentName", "attributeName", "namespaceCode", "attributeLabel", "active", "versionNumber", "objectId", "_futureElements"})
public final class KimAttribute
extends AbstractDataTransferObject
implements KimAttributeContract {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="id", required=false)
    private final String id;
    @XmlElement(name="componentName", required=false)
    private final String componentName;
    @XmlElement(name="attributeName", required=true)
    private final String attributeName;
    @XmlElement(name="namespaceCode", required=true)
    private final String namespaceCode;
    @XmlElement(name="attributeLabel", required=false)
    private final String attributeLabel;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KimAttribute() {
        this.id = null;
        this.componentName = null;
        this.attributeName = null;
        this.namespaceCode = null;
        this.attributeLabel = null;
        this.active = false;
        this.versionNumber = 1L;
        this.objectId = null;
    }

    private KimAttribute(Builder builder) {
        this.id = builder.getId();
        this.componentName = builder.getComponentName();
        this.attributeName = builder.getAttributeName();
        this.namespaceCode = builder.getNamespaceCode();
        this.attributeLabel = builder.getAttributeLabel();
        this.active = builder.isActive();
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
    }

    public String getId() {
        return this.id;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getAttributeName() {
        return this.attributeName;
    }

    @Override
    public String getNamespaceCode() {
        return this.namespaceCode;
    }

    @Override
    public String getAttributeLabel() {
        return this.attributeLabel;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public static final class Builder
    implements KimAttributeContract,
    ModelBuilder,
    Serializable {
        private String id;
        private String componentName;
        private String attributeName;
        private String namespaceCode;
        private String attributeLabel;
        private boolean active;
        private Long versionNumber;
        private String objectId;

        private Builder(String componentName, String attributeName, String namespaceCode) {
            this.setComponentName(componentName);
            this.setAttributeName(attributeName);
            this.setNamespaceCode(namespaceCode);
        }

        public static Builder create(String componentName, String attributeName, String namespaceCode) {
            return new Builder(componentName, attributeName, namespaceCode);
        }

        public static Builder create(KimAttributeContract contract) {
            Builder builder = new Builder(contract.getComponentName(), contract.getAttributeName(), contract.getNamespaceCode());
            builder.setId(contract.getId());
            builder.setAttributeLabel(contract.getAttributeLabel());
            builder.setActive(contract.isActive());
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            return builder;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        @Override
        public String getComponentName() {
            return this.componentName;
        }

        public void setComponentName(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public String getAttributeName() {
            return this.attributeName;
        }

        public void setAttributeName(String attributeName) {
            if (StringUtils.isBlank((String)attributeName)) {
                throw new IllegalArgumentException("attributeName is blank");
            }
            this.attributeName = attributeName;
        }

        @Override
        public String getNamespaceCode() {
            return this.namespaceCode;
        }

        public void setNamespaceCode(String namespaceCode) {
            if (StringUtils.isBlank((String)namespaceCode)) {
                throw new IllegalArgumentException("namespaceCode is blank");
            }
            this.namespaceCode = namespaceCode;
        }

        @Override
        public String getAttributeLabel() {
            return this.attributeLabel;
        }

        public void setAttributeLabel(String attributeLabel) {
            this.attributeLabel = attributeLabel;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public KimAttribute build() {
            return new KimAttribute(this);
        }
    }

    public static class Cache {
        public static final String NAME = "http://rice.kuali.org/kim/v2_0/KimAttributeType";
    }

    static class Elements {
        static final String ID = "id";
        static final String COMPONENT_NAME = "componentName";
        static final String ATTRIBUTE_NAME = "attributeName";
        static final String NAMESPACE_CODE = "namespaceCode";
        static final String ATTRIBUTE_LABEL = "attributeLabel";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kimAttribute";
        static final String TYPE_NAME = "KimAttributeType";

        Constants() {
        }
    }
}

