/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.identity.type;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.CodedAttributeContract;
import org.kuali.rice.kim.api.identity.EntityUtils;
import org.kuali.rice.kim.api.identity.address.EntityAddress;
import org.kuali.rice.kim.api.identity.address.EntityAddressContract;
import org.kuali.rice.kim.api.identity.email.EntityEmail;
import org.kuali.rice.kim.api.identity.email.EntityEmailContract;
import org.kuali.rice.kim.api.identity.phone.EntityPhone;
import org.kuali.rice.kim.api.identity.phone.EntityPhoneContract;
import org.kuali.rice.kim.api.identity.type.EntityTypeContactInfoContract;
import org.w3c.dom.Element;

@XmlRootElement(name="entityTypeContactInfo")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="EntityTypeContactInfoType", propOrder={"entityId", "entityTypeCode", "entityType", "addresses", "emailAddresses", "phoneNumbers", "defaultAddress", "defaultEmailAddress", "defaultPhoneNumber", "versionNumber", "objectId", "active", "_futureElements"})
public final class EntityTypeContactInfo
extends AbstractDataTransferObject
implements EntityTypeContactInfoContract {
    @XmlElement(name="entityId", required=true)
    private final String entityId;
    @XmlElement(name="entityTypeCode", required=true)
    private final String entityTypeCode;
    @XmlElement(name="entityType", required=false)
    private final CodedAttribute entityType;
    @XmlElementWrapper(name="addresses", required=false)
    @XmlElement(name="address", required=false)
    private final List<EntityAddress> addresses;
    @XmlElementWrapper(name="emailAddresses", required=false)
    @XmlElement(name="emailAddress", required=false)
    private final List<EntityEmail> emailAddresses;
    @XmlElementWrapper(name="phoneNumbers", required=false)
    @XmlElement(name="phoneNumber", required=false)
    private final List<EntityPhone> phoneNumbers;
    @XmlElement(name="defaultAddress", required=false)
    private final EntityAddress defaultAddress;
    @XmlElement(name="defaultEmailAddress", required=false)
    private final EntityEmail defaultEmailAddress;
    @XmlElement(name="defaultPhoneNumber", required=false)
    private final EntityPhone defaultPhoneNumber;
    @XmlElement(name="versionNumber", required=false)
    private final Long versionNumber;
    @XmlElement(name="objectId", required=false)
    private final String objectId;
    @XmlElement(name="active", required=false)
    private final boolean active;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private EntityTypeContactInfo() {
        this.entityId = null;
        this.entityTypeCode = null;
        this.entityType = null;
        this.addresses = null;
        this.emailAddresses = null;
        this.phoneNumbers = null;
        this.defaultAddress = null;
        this.defaultEmailAddress = null;
        this.defaultPhoneNumber = null;
        this.versionNumber = null;
        this.objectId = null;
        this.active = false;
    }

    private EntityTypeContactInfo(Builder builder) {
        this.entityId = builder.getEntityId();
        this.entityTypeCode = builder.getEntityTypeCode();
        this.entityType = builder.getEntityType() != null ? builder.getEntityType().build() : null;
        this.addresses = new ArrayList<EntityAddress>();
        if (!CollectionUtils.isEmpty(builder.getAddresses())) {
            for (EntityAddress.Builder address : builder.getAddresses()) {
                this.addresses.add(address.build());
            }
        }
        this.emailAddresses = new ArrayList<EntityEmail>();
        if (!CollectionUtils.isEmpty(builder.getEmailAddresses())) {
            for (EntityEmail.Builder email : builder.getEmailAddresses()) {
                this.emailAddresses.add(email.build());
            }
        }
        this.phoneNumbers = new ArrayList<EntityPhone>();
        if (!CollectionUtils.isEmpty(builder.getPhoneNumbers())) {
            for (EntityPhone.Builder phoneNumber : builder.getPhoneNumbers()) {
                this.phoneNumbers.add(phoneNumber.build());
            }
        }
        this.defaultAddress = builder.getDefaultAddress() != null ? builder.getDefaultAddress().build() : null;
        this.defaultEmailAddress = builder.getDefaultEmailAddress() != null ? builder.getDefaultEmailAddress().build() : null;
        this.defaultPhoneNumber = builder.getDefaultPhoneNumber() != null ? builder.getDefaultPhoneNumber().build() : null;
        this.versionNumber = builder.getVersionNumber();
        this.objectId = builder.getObjectId();
        this.active = builder.isActive();
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    @Override
    public String getEntityTypeCode() {
        return this.entityTypeCode;
    }

    @Override
    public CodedAttributeContract getEntityType() {
        return this.entityType;
    }

    public List<EntityAddress> getAddresses() {
        return this.addresses;
    }

    public List<EntityEmail> getEmailAddresses() {
        return this.emailAddresses;
    }

    public List<EntityPhone> getPhoneNumbers() {
        return this.phoneNumbers;
    }

    @Override
    public EntityAddressContract getDefaultAddress() {
        return this.defaultAddress;
    }

    @Override
    public EntityEmail getDefaultEmailAddress() {
        return this.defaultEmailAddress;
    }

    @Override
    public EntityPhoneContract getDefaultPhoneNumber() {
        return this.defaultPhoneNumber;
    }

    public Long getVersionNumber() {
        return this.versionNumber;
    }

    public String getObjectId() {
        return this.objectId;
    }

    public boolean isActive() {
        return this.active;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    EntityTypeContactInfoContract {
        private String entityId;
        private String entityTypeCode;
        private CodedAttribute.Builder entityType;
        private List<EntityAddress.Builder> addresses;
        private List<EntityEmail.Builder> emailAddresses;
        private List<EntityPhone.Builder> phoneNumbers;
        private Long versionNumber;
        private String objectId;
        private boolean active;

        private Builder(String entityId, String entityTypeCode) {
            this.setEntityId(entityId);
            this.setEntityTypeCode(entityTypeCode);
            this.setEntityType(CodedAttribute.Builder.create(entityTypeCode));
        }

        public static Builder create(String entityId, String entityTypeCode) {
            return new Builder(entityId, entityTypeCode);
        }

        public static Builder create(EntityTypeContactInfoContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder builder = Builder.create(contract.getEntityId(), contract.getEntityTypeCode());
            if (contract.getEntityType() != null) {
                builder.setEntityType(CodedAttribute.Builder.create(contract.getEntityType()));
            }
            builder.addresses = new ArrayList<EntityAddress.Builder>();
            if (!CollectionUtils.isEmpty(contract.getAddresses())) {
                for (EntityAddressContract entityAddressContract : contract.getAddresses()) {
                    builder.addresses.add(EntityAddress.Builder.create(entityAddressContract));
                }
            }
            builder.emailAddresses = new ArrayList<EntityEmail.Builder>();
            if (!CollectionUtils.isEmpty(contract.getEmailAddresses())) {
                for (EntityEmailContract entityEmailContract : contract.getEmailAddresses()) {
                    builder.emailAddresses.add(EntityEmail.Builder.create(entityEmailContract));
                }
            }
            builder.phoneNumbers = new ArrayList<EntityPhone.Builder>();
            if (!CollectionUtils.isEmpty(contract.getPhoneNumbers())) {
                for (EntityPhoneContract entityPhoneContract : contract.getPhoneNumbers()) {
                    builder.phoneNumbers.add(EntityPhone.Builder.create(entityPhoneContract));
                }
            }
            builder.setVersionNumber(contract.getVersionNumber());
            builder.setObjectId(contract.getObjectId());
            builder.setActive(contract.isActive());
            return builder;
        }

        public EntityTypeContactInfo build() {
            return new EntityTypeContactInfo(this);
        }

        @Override
        public String getEntityId() {
            return this.entityId;
        }

        @Override
        public String getEntityTypeCode() {
            return this.entityTypeCode;
        }

        @Override
        public CodedAttribute.Builder getEntityType() {
            return this.entityType;
        }

        public List<EntityAddress.Builder> getAddresses() {
            return this.addresses;
        }

        public List<EntityEmail.Builder> getEmailAddresses() {
            return this.emailAddresses;
        }

        public List<EntityPhone.Builder> getPhoneNumbers() {
            return this.phoneNumbers;
        }

        @Override
        public EntityAddress.Builder getDefaultAddress() {
            return EntityUtils.getDefaultItem(this.addresses);
        }

        @Override
        public EntityEmail.Builder getDefaultEmailAddress() {
            return EntityUtils.getDefaultItem(this.emailAddresses);
        }

        @Override
        public EntityPhone.Builder getDefaultPhoneNumber() {
            return EntityUtils.getDefaultItem(this.phoneNumbers);
        }

        public Long getVersionNumber() {
            return this.versionNumber;
        }

        public String getObjectId() {
            return this.objectId;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setEntityId(String entityId) {
            if (StringUtils.isEmpty((String)entityId)) {
                throw new IllegalArgumentException("entityId is empty");
            }
            this.entityId = entityId;
        }

        public void setEntityTypeCode(String entityTypeCode) {
            if (StringUtils.isEmpty((String)entityTypeCode)) {
                throw new IllegalArgumentException("entityTypeCode is empty");
            }
            this.entityTypeCode = entityTypeCode;
        }

        public void setEntityType(CodedAttribute.Builder entityType) {
            this.entityType = entityType;
        }

        public void setAddresses(List addresses) {
            this.addresses = addresses;
        }

        public void setEmailAddresses(List emailAddresses) {
            this.emailAddresses = emailAddresses;
        }

        public void setPhoneNumbers(List phoneNumbers) {
            this.phoneNumbers = phoneNumbers;
        }

        public void setVersionNumber(Long versionNumber) {
            this.versionNumber = versionNumber;
        }

        public void setObjectId(String objectId) {
            this.objectId = objectId;
        }

        public void setActive(boolean active) {
            this.active = active;
        }
    }

    static class Elements {
        static final String ENTITY_ID = "entityId";
        static final String ENTITY_TYPE_CODE = "entityTypeCode";
        static final String ENTITY_TYPE = "entityType";
        static final String ADDRESSES = "addresses";
        static final String ADDRESS = "address";
        static final String EMAIL_ADDRESSES = "emailAddresses";
        static final String EMAIL_ADDRESS = "emailAddress";
        static final String PHONE_NUMBERS = "phoneNumbers";
        static final String PHONE_NUMBER = "phoneNumber";
        static final String DEFAULT_ADDRESS = "defaultAddress";
        static final String DEFAULT_EMAIL_ADDRESS = "defaultEmailAddress";
        static final String DEFAULT_PHONE_NUMBER = "defaultPhoneNumber";
        static final String ACTIVE = "active";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "entityTypeContactInfo";
        static final String TYPE_NAME = "EntityTypeContactInfoType";

        Constants() {
        }
    }
}

