/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.api.type;

import java.io.Serializable;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.core.api.mo.AbstractDataTransferObject;
import org.kuali.rice.core.api.mo.ModelBuilder;
import org.kuali.rice.core.api.uif.RemotableAttributeField;
import org.kuali.rice.core.api.uif.RemotableAttributeFieldContract;
import org.kuali.rice.kim.api.type.KimAttributeFieldContract;
import org.w3c.dom.Element;

@XmlRootElement(name="kimAttributeField")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="KimAttributeFieldType", propOrder={"attributeField", "id", "unique", "_futureElements"})
public final class KimAttributeField
extends AbstractDataTransferObject
implements KimAttributeFieldContract {
    @XmlElement(name="attributeField", required=true)
    private final RemotableAttributeField attributeField;
    @XmlElement(name="id", required=true)
    private final String id;
    @XmlElement(name="unique", required=false)
    private final boolean unique;
    @XmlAnyElement
    private final Collection<Element> _futureElements = null;

    private KimAttributeField() {
        this.attributeField = null;
        this.id = null;
        this.unique = false;
    }

    private KimAttributeField(Builder builder) {
        this.attributeField = builder.getAttributeField().build();
        this.id = builder.getId();
        this.unique = builder.isUnique();
    }

    public RemotableAttributeField getAttributeField() {
        return this.attributeField;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isUnique() {
        return this.unique;
    }

    public static KimAttributeField findAttribute(String attributeName, Collection<KimAttributeField> fields) {
        if (StringUtils.isBlank((String)attributeName)) {
            throw new IllegalArgumentException("attributeName is blank");
        }
        if (fields == null) {
            throw new IllegalArgumentException("errors is null");
        }
        for (KimAttributeField field : fields) {
            if (!attributeName.equals(field.getAttributeField().getName())) continue;
            return field;
        }
        return null;
    }

    public static final class Builder
    implements Serializable,
    ModelBuilder,
    KimAttributeFieldContract {
        private RemotableAttributeField.Builder attributeField;
        private String id;
        private boolean unique;

        private Builder(RemotableAttributeField.Builder attributeField, String id) {
            this.setAttributeField(attributeField);
            this.setId(id);
        }

        public static Builder create(RemotableAttributeField.Builder attributeField, String id) {
            return new Builder(attributeField, id);
        }

        public static Builder create(KimAttributeFieldContract contract) {
            if (contract == null) {
                throw new IllegalArgumentException("contract was null");
            }
            Builder b = Builder.create(RemotableAttributeField.Builder.create((RemotableAttributeFieldContract)contract.getAttributeField()), contract.getId());
            b.setUnique(contract.isUnique());
            return b;
        }

        public KimAttributeField build() {
            return new KimAttributeField(this);
        }

        public RemotableAttributeField.Builder getAttributeField() {
            return this.attributeField;
        }

        public String getId() {
            return this.id;
        }

        @Override
        public boolean isUnique() {
            return this.unique;
        }

        public void setAttributeField(RemotableAttributeField.Builder attributeField) {
            if (attributeField == null) {
                throw new IllegalArgumentException("attributeField is null");
            }
            this.attributeField = attributeField;
        }

        public void setId(String id) {
            if (StringUtils.isBlank((String)id)) {
                throw new IllegalArgumentException("id is blank");
            }
            this.id = id;
        }

        public void setUnique(boolean unique) {
            this.unique = unique;
        }
    }

    static class Elements {
        static final String ATTRIBUTE_FIELD = "attributeField";
        static final String ID = "id";
        static final String UNIQUE = "unique";

        Elements() {
        }
    }

    static class Constants {
        static final String ROOT_ELEMENT_NAME = "kimAttributeField";
        static final String TYPE_NAME = "KimAttributeFieldType";

        Constants() {
        }
    }
}

