/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.common.template;

import org.kuali.rice.core.api.mo.common.GloballyUnique;
import org.kuali.rice.core.api.mo.common.Identifiable;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;
/**
 *
 * This is a contract for a Template. A template represents some course-grained information that is used to
 * create a permission or responsibility which then contains more specific
 * information in permission details or responsibility details.
 * Eg: of a template would be Use Screen,Maintain records etc.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */

public interface TemplateContract extends Versioned, GloballyUnique, Inactivatable, Identifiable {
    /**
     * The namespace code that this KIM Permission Template belongs too.
     *
     * @return namespaceCode
     */
    String getNamespaceCode();

    /**
     * The name of the KIM Permission Template.
     *
     * @return name
     */
    String getName();

    /**
     * The description of the KIM Permission Template.
     *
     * @return description
     */
	String getDescription();

    /**
     * The KIM Type ID referenced by the KIM Permission Template.
     *
     * @return typeId
     */
	String getKimTypeId();
}
