/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.role;

import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.Inactivatable;

/**
 * An lightweight association of a Responsibility and a Role represented by references to the identifiers of a
 * Role and a Responsibility that are related to each other.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public interface RoleResponsibilityContract extends Versioned, Inactivatable {

    /**
     * Provides the String identifier for a given RoleResponsibility
     *
     * @return id of the Role/Responsibility contract
     */
    String getRoleResponsibilityId();

    /**
     * Returns the String identifier for the Role represented by this Role/Responsibility association.
     *
     * @return Role Id
     */
    String getRoleId();

    /**
     * Returns the String identifier for the Responsibility represented by this Role/Responsibility association.
     *
     * @return Responsibility Id
     */
    String getResponsibilityId();
}
