/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.api.common.delegate;

import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.core.api.mo.common.Versioned;
import org.kuali.rice.core.api.mo.common.active.InactivatableFromTo;

import java.util.Map;
/**
 * This is a contract for a DelegateMember. Delegates are users that a member of a
 * Role has authorized to have the same Permissions and take the same actions as that
 * member is authorized to take.
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */

public interface DelegateMemberContract extends Versioned, InactivatableFromTo {

    String getDelegationMemberId();

    String getDelegationId();

    String getRoleMemberId();

    MemberType getType();

    String getMemberId();

    Map<String, String> getAttributes();
}
