/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.framework.responsibility;


import org.kuali.rice.core.api.exception.RiceIllegalArgumentException;
import org.kuali.rice.core.api.util.jaxb.MapStringStringAdapter;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.framework.type.KimTypeService;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.List;
import java.util.Map;

/**
 * A {@link KimTypeService} with specific methods for Responsibilities.
 */
@WebService(name = "responsibilityTypeService", targetNamespace = KimConstants.Namespaces.KIM_NAMESPACE_2_0)
@SOAPBinding(style = SOAPBinding.Style.DOCUMENT, use = SOAPBinding.Use.LITERAL, parameterStyle = SOAPBinding.ParameterStyle.WRAPPED)
public interface ResponsibilityTypeService extends KimTypeService {

    /** Gets whether a responsibility assignment with the given details is applicable for the given request details.
     *
     * For example, the details for a responsibilities (say approve) could be as follows:
     *   component = Account
     *   field = incomeStreamAccountNumber
     *
     * The Account component is known to belong to the KFS-COA namespace.  If this service is requested...
     * component = Account, field = All
     *
     * @param requestedDetails the requested details.  cannot be null.
     * @param responsibilities the list of responsibilities to check for matches. cannot be null.
     * @return an immutable list of matched responsibilities.  will not return null.
     * @throws IllegalArgumentException if the requestedDetails or responsibilities is null.
     */
    @WebMethod(operationName="getMatchingResponsibilities")
    @XmlElementWrapper(name = "responsibilities", required = true)
    @XmlElement(name = "responsibility", required = false)
    @WebResult(name = "responsibilities")
    List<Responsibility> getMatchingResponsibilities(@WebParam(name = "requestedDetails")
                                            @XmlJavaTypeAdapter(value = MapStringStringAdapter.class)
                                            Map<String, String> requestedDetails,
                                            @WebParam(name = "responsibilities")
                                            List<Responsibility> responsibilities) throws RiceIllegalArgumentException;
}
