/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.citizenship;

import java.sql.Timestamp;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.api.identity.citizenship.EntityCitizenship;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name = "KRIM_ENTITY_CTZNSHP_T")
public class EntityCitizenshipBo extends EntityCitizenshipBase {

    private static final long serialVersionUID = 1L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_CTZNSHP_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_CTZNSHP_ID_S")
    @Id
    @Column(name = "ENTITY_CTZNSHP_ID")
    private String id;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityCitizenshipStatusBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "CTZNSHP_STAT_CD", referencedColumnName = "CTZNSHP_STAT_CD", insertable = false, updatable = false)
    private EntityCitizenshipStatusBo status;

    @Transient
    private EntityCitizenshipChangeTypeBo changeType;

    public static EntityCitizenship to(EntityCitizenshipBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityCitizenship.Builder.create(bo).build();
    }

    /**
     * Creates a EntityCitizenshipBo business object from an immutable representation of a EntityCitizenship.
     *
     * @param immutable an immutable EntityCitizenship
     * @return a EntityCitizenshipBo
     */
    public static EntityCitizenshipBo from(EntityCitizenship immutable) {
        if (immutable == null) {
            return null;
        }
        EntityCitizenshipBo bo = new EntityCitizenshipBo();
        bo.setActive(immutable.isActive());
        if (immutable.getStatus() != null) {
            bo.setStatusCode(immutable.getStatus().getCode());
            bo.setStatus(EntityCitizenshipStatusBo.from(immutable.getStatus()));
        }
        bo.setId(immutable.getId());
        bo.setEntityId(immutable.getEntityId());
        bo.setCountryCode(immutable.getCountryCode());
        if (immutable.getStartDate() != null) {
            bo.setStartDateValue(new Timestamp(immutable.getStartDate().getMillis()));
        }
        if (immutable.getEndDate() != null) {
            bo.setEndDateValue(new Timestamp(immutable.getEndDate().getMillis()));
        }
        bo.setActive(immutable.isActive());
        bo.setVersionNumber(immutable.getVersionNumber());
        bo.setObjectId(immutable.getObjectId());
        return bo;
    }

    @Override
    public EntityCitizenshipStatusBo getStatus() {
        return this.status;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStatus(EntityCitizenshipStatusBo status) {
        this.status = status;
    }
}
