/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.name;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.framework.identity.name.EntityNameTypeEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;

@AttributeOverrides({ @AttributeOverride(name = "code", column = @Column(name = "ENT_NM_TYP_CD")) })
@Entity
@Table(name = "KRIM_ENT_NM_TYP_T")
public class EntityNameTypeBo extends CodedAttributeBo implements EntityNameTypeEbo {

    private static final long serialVersionUID = -3667881155839568604L;

    public static EntityNameTypeBo from(CodedAttribute immutable) {
        return CodedAttributeBo.from(EntityNameTypeBo.class, immutable);
    }
}
