/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.membership;

import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.impl.common.active.ActiveFromToBo;

import javax.persistence.Column;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
public abstract class AbstractMemberBo extends ActiveFromToBo {
    private static final long serialVersionUID = 1L;
    
    @Column(name = "MBR_ID")
    private String memberId;
    @Column(name = "MBR_TYP_CD")
    private String typeCode;

    public String getMemberId() {
        return this.memberId;
    }

    public void setMemberId(String memberId) {
        this.memberId = memberId;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public void setType(MemberType type) {
        typeCode = type.getCode();
    }

    public MemberType getType() {
        return MemberType.fromCode(typeCode);
    }

    public String getTypeCode() {
        return this.typeCode;
    }

}
