/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.type;

import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kns.inquiry.KualiInquirableImpl;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.krad.bo.BusinessObject;

import java.util.Collections;

public class KimTypeInquirableImpl extends KualiInquirableImpl {

	protected final String KIM_TYPE_NAME = "name";
	
    @Override
    public HtmlData getInquiryUrl(BusinessObject businessObject, String attributeName, boolean forceInquiry) {
		if(KIM_TYPE_NAME.equals(attributeName)){
			return getInquiryUrlForPrimaryKeys(KimTypeBo.class, businessObject, Collections.singletonList(KimConstants.PrimaryKeyConstants.KIM_TYPE_ID), null);
		}
        return super.getInquiryUrl(businessObject, attributeName, forceInquiry);
    }

}
