/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.responsibility;

import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.rice.kim.api.role.RoleResponsibility;
import org.kuali.rice.kim.impl.common.delegate.DelegateMemberBo;
import org.kuali.rice.kim.impl.role.RoleMemberBo;

import java.util.List;
import java.util.Set;

/**
 * This is an internal service that was created as a proxy for kew
 * updates
 *
 * @author Kuali Rice Team (rice.collab@kuali.org)
 *
 */
public interface ResponsibilityInternalService {

	void updateActionRequestsForResponsibilityChange(Set<String> responsibilityIds);
	RoleMemberBo saveRoleMember(RoleMemberBo roleMember);
    DelegateMemberBo saveDelegateMember(DelegateMemberBo delegateMember);
	void removeRoleMember(RoleMemberBo roleMember);
	void updateActionRequestsForRoleChange(String roleId);

        /**
     * Lets the system know (mainly for UI purposes) whether this responsibility expects RoleResponsibilityAction
     * records to be given at the assignment level or are global to the responsibility.  (I.e., they apply
     * to any member assigned to the responsibility.)
     */
   	boolean areActionsAtAssignmentLevelById(String responsibilityId );

    /**
     * Lets the system know (mainly for UI purposes) whether this responsibility expects RoleResponsibilityAction
     * records to be given at the assignment level or are global to the responsibility.  (I.e., they apply
     * to any member assigned to the responsibility.)
     */
   	boolean areActionsAtAssignmentLevel(Responsibility responsibility );
   	
   	/**
   	 * Get all the role-responsibility records attached to the given role.
   	 */
   	public List<RoleResponsibility> getRoleResponsibilities(String roleId);
}
