/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2025 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kim.impl.identity.affiliation;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.eclipse.persistence.annotations.JoinFetch;
import org.eclipse.persistence.annotations.JoinFetchType;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.krad.data.jpa.PortableSequenceGenerator;

@Entity
@Table(name = "KRIM_ENTITY_AFLTN_T")
public class EntityAffiliationBo extends EntityAffiliationBase {

    private static final long serialVersionUID = 0L;

    @PortableSequenceGenerator(name = "KRIM_ENTITY_AFLTN_ID_S")
    @GeneratedValue(generator = "KRIM_ENTITY_AFLTN_ID_S")
    @Id
    @Column(name = "ENTITY_AFLTN_ID")
    private String id;

    @JoinFetch(value= JoinFetchType.OUTER)
    @ManyToOne(targetEntity = EntityAffiliationTypeBo.class, cascade = { CascadeType.REFRESH })
    @JoinColumn(name = "AFLTN_TYP_CD", referencedColumnName = "AFLTN_TYP_CD", insertable = false, updatable = false)
    private EntityAffiliationTypeBo affiliationType;

    public static EntityAffiliation to(EntityAffiliationBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityAffiliation.Builder.create(bo).build();
    }

    /**
     * Creates a EntityAffiliationBo business object from an immutable representation of a EntityAffiliation.
     *
     * @param immutable an immutable EntityAffiliation
     * @return a EntityAffiliationBo
     */
    public static EntityAffiliationBo from(EntityAffiliation immutable) {
        if (immutable == null) {
            return null;
        }
        EntityAffiliationBo bo = new EntityAffiliationBo();
        bo.setActive(immutable.isActive());
        if (immutable.getAffiliationType() != null) {
            bo.setAffiliationTypeCode(immutable.getAffiliationType().getCode());
            bo.setAffiliationType(EntityAffiliationTypeBo.from(immutable.getAffiliationType()));
        }
        bo.setId(immutable.getId());
        bo.setCampusCode(immutable.getCampusCode());
        bo.setEntityId(immutable.getEntityId());
        bo.setActive(immutable.isActive());
        bo.setDefaultValue(immutable.isDefaultValue());
        bo.setVersionNumber(immutable.getVersionNumber());
        return bo;
    }

    @Override
    public EntityAffiliationTypeBo getAffiliationType() {
        return this.affiliationType;
    }

    public void setAffiliationType(EntityAffiliationTypeBo affiliationType) {
        this.affiliationType = affiliationType;
    }

    @Override
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }
}
