/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2026 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */



package org.kuali.rice.kim.impl.identity.affiliation;

import org.kuali.rice.kim.api.identity.CodedAttribute;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliationType;
import org.kuali.rice.kim.framework.identity.affiliation.EntityAffiliationTypeEbo;
import org.kuali.rice.kim.impl.identity.CodedAttributeBo;
import org.kuali.rice.krad.data.jpa.converters.BooleanYNConverter;

import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Table;

@AttributeOverrides({@AttributeOverride(name="code",column=@Column(name="AFLTN_TYP_CD"))})
@Entity
@Table(name = "KRIM_AFLTN_TYP_T")
public class EntityAffiliationTypeBo extends CodedAttributeBo implements EntityAffiliationTypeEbo {

    private static final long serialVersionUID = 4973602240626940004L;

    @Column(name = "EMP_AFLTN_TYP_IND")
    @Convert(converter = BooleanYNConverter.class)
    private boolean employmentAffiliationType;

    public static EntityAffiliationTypeBo from(EntityAffiliationType immutable) {
        EntityAffiliationTypeBo bo = CodedAttributeBo.from(EntityAffiliationTypeBo.class, CodedAttribute.Builder.create(immutable).build());
        bo.setEmploymentAffiliationType(immutable.isEmploymentAffiliationType());
        return bo;
    }

    public static EntityAffiliationType to(EntityAffiliationTypeBo bo) {
        if (bo == null) {
            return null;
        }
        return EntityAffiliationType.Builder.create(bo).build();
    }

    @Override
    public boolean isEmploymentAffiliationType() {
        return employmentAffiliationType;
    }

    public void setEmploymentAffiliationType(boolean employmentAffiliationType) {
        this.employmentAffiliationType = employmentAffiliationType;
    }
}
