/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.rice.kim.ldap;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.kuali.rice.kim.api.identity.affiliation.EntityAffiliation;
import org.kuali.rice.kim.api.identity.employment.EntityEmployment;
import org.kuali.rice.kim.api.identity.entity.Entity;
import org.kuali.rice.kim.api.identity.external.EntityExternalIdentifier;
import org.kuali.rice.kim.api.identity.name.EntityName;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.ldap.BaseMapper;
import org.kuali.rice.kim.ldap.EntityAffiliationMapper;
import org.kuali.rice.kim.ldap.EntityEmploymentMapper;
import org.kuali.rice.kim.ldap.EntityNameMapper;
import org.kuali.rice.kim.ldap.EntityTypeContactInfoMapper;
import org.kuali.rice.kim.ldap.InvalidLdapEntityException;
import org.springframework.ldap.core.DirContextOperations;

public class EntityMapper
extends BaseMapper<Entity> {
    private EntityAffiliationMapper affiliationMapper;
    private EntityTypeContactInfoMapper entityTypeContactInfoMapper;
    private EntityNameMapper defaultNameMapper;
    private EntityEmploymentMapper employmentMapper;

    @Override
    Entity mapDtoFromContext(DirContextOperations context) {
        Entity.Builder builder = this.mapBuilderFromContext(context);
        return builder != null ? builder.build() : null;
    }

    Entity.Builder mapBuilderFromContext(DirContextOperations context) {
        String entityId = context.getStringAttribute(this.getConstants().getKimLdapIdProperty());
        String principalName = context.getStringAttribute(this.getConstants().getKimLdapNameProperty());
        Entity.Builder person = Entity.Builder.create();
        person.setId(entityId);
        if (entityId == null) {
            throw new InvalidLdapEntityException("LDAP Search Results yielded an invalid result with attributes " + context.getAttributes());
        }
        person.setAffiliations(new ArrayList());
        person.setExternalIdentifiers(new ArrayList());
        EntityExternalIdentifier.Builder externalId = EntityExternalIdentifier.Builder.create();
        externalId.setExternalIdentifierTypeCode(this.getConstants().getTaxExternalIdTypeCode());
        externalId.setExternalId(entityId);
        person.getExternalIdentifiers().add(externalId);
        person.setAffiliations(this.getAffiliationMapper().mapBuilderFromContext(context));
        person.setEntityTypes(new ArrayList());
        person.getEntityTypeContactInfos().add(this.getEntityTypeContactInfoMapper().mapBuilderFromContext(context));
        ArrayList<EntityName.Builder> names = new ArrayList<EntityName.Builder>();
        EntityName.Builder name = this.getDefaultNameMapper().mapBuilderFromContext(context);
        names.add(name);
        name.setDefaultValue(true);
        person.setNames(names);
        person.setId(entityId);
        EntityEmployment.Builder employmentInfo = (EntityEmployment.Builder)this.getEmploymentMapper().mapFromContext(context);
        EntityAffiliation.Builder employeeAffiliation = this.getAffiliation(this.getConstants().getEmployeeAffiliationCodes(), person);
        if (employeeAffiliation != null && employmentInfo != null) {
            employeeAffiliation.getAffiliationType().setEmploymentAffiliationType(true);
            employmentInfo.setEntityAffiliation(employeeAffiliation);
            person.getEmploymentInformation().add(employmentInfo);
        }
        person.setPrincipals(new ArrayList());
        person.setActive(true);
        Principal.Builder defaultPrincipal = Principal.Builder.create((String)principalName);
        defaultPrincipal.setPrincipalId(entityId);
        defaultPrincipal.setEntityId(entityId);
        person.getPrincipals().add(defaultPrincipal);
        return person;
    }

    protected EntityAffiliation.Builder getAffiliation(String affiliationCodes, Entity.Builder person) {
        EntityAffiliation.Builder retval = null;
        for (EntityAffiliation.Builder affil : person.getAffiliations()) {
            if (!StringUtils.contains((String)affiliationCodes, (String)affil.getAffiliationType().getCode())) continue;
            return affil;
        }
        return retval;
    }

    public final EntityAffiliationMapper getAffiliationMapper() {
        return this.affiliationMapper;
    }

    public final void setAffiliationMapper(EntityAffiliationMapper argAffiliationMapper) {
        this.affiliationMapper = argAffiliationMapper;
    }

    public final EntityTypeContactInfoMapper getEntityTypeContactInfoMapper() {
        return this.entityTypeContactInfoMapper;
    }

    public final void setEntityTypeContactInfoMapper(EntityTypeContactInfoMapper entityTypeContactInfoMapper) {
        this.entityTypeContactInfoMapper = entityTypeContactInfoMapper;
    }

    public final EntityNameMapper getDefaultNameMapper() {
        return this.defaultNameMapper;
    }

    public final void setDefaultNameMapper(EntityNameMapper defaultNameMapper) {
        this.defaultNameMapper = defaultNameMapper;
    }

    public final EntityEmploymentMapper getEmploymentMapper() {
        return this.employmentMapper;
    }

    public final void setEmploymentMapper(EntityEmploymentMapper employmentMapper) {
        this.employmentMapper = employmentMapper;
    }
}

