/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.apache.ojb.broker.platforms;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;

@Deprecated
public class KualiMySQLSequenceManagerImpl extends AbstractSequenceManager {

	public KualiMySQLSequenceManagerImpl(PersistenceBroker broker) {
		super(broker);
	}

	@Override
	protected long getUniqueLong(FieldDescriptor arg0) {
		final PersistenceBroker broker = getBrokerForClass();
		final String sequenceName = arg0.getSequenceName();

		Long seqNumber = null;
		try {
			final Connection c = broker.serviceConnectionManager().getConnection();
			try (Statement stmt = c.createStatement()) {
				stmt.executeUpdate("INSERT INTO " + sequenceName + " VALUES (NULL);");
				try (ResultSet rs = stmt.executeQuery("SELECT LAST_INSERT_ID()")) {
					if (rs != null && rs.next()) {
						return rs.getLong(1);
					}
				}
			}
		} catch (Exception e) {
			throw new RuntimeException("Unable to execute for sequence name: " + sequenceName, e);
		}

		return seqNumber;
	}

}
