/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */
package org.kuali.rice.core.framework.persistence.ojb;

import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import net.bytebuddy.implementation.InvocationHandlerAdapter;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.ojb.broker.core.proxy.AbstractProxyFactory;
import org.apache.ojb.broker.core.proxy.IndirectionHandler;
import org.apache.ojb.broker.core.proxy.OJBProxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyFactoryByteBuddyImpl extends AbstractProxyFactory {

    private static final String OJB_INVOCATION_HANDLER_FIELD = "ojbInvocationHandler";
    private final ConcurrentHashMap<Class<?>, Class<? extends OJBProxy>> proxyFactories = new ConcurrentHashMap<>();

    @Override
    protected IndirectionHandler getDynamicIndirectionHandler(Object obj) {
        return ((OJBProxy) obj).getIndirectionHandler();
    }

    @Override
    public Class<IndirectionHandlerByteBuddyImpl> getDefaultIndirectionHandlerClass() {
        return IndirectionHandlerByteBuddyImpl.class;
    }

    @Override
    public Class<IndirectionHandlerByteBuddy> getIndirectionHandlerBaseClass() {
        return IndirectionHandlerByteBuddy.class;
    }

    @Override
    @SuppressWarnings("unchecked")
    public OJBProxy createProxy(Class baseClass, IndirectionHandler handler) throws Exception {
        final Class<? extends OJBProxy> proxyClass = proxyFactories.computeIfAbsent(baseClass, aClass ->
                new ByteBuddy(ClassFileVersion.JAVA_V17)
                .subclass(baseClass)
                .implement(OJBProxy.class)
                .name(baseClass.getName() + ".ByteBuddyOJBProxy")
                .defineField(OJB_INVOCATION_HANDLER_FIELD, InvocationHandler.class, Modifier.PUBLIC)
                .method(ElementMatchers.any())
                .intercept(InvocationHandlerAdapter.toField(OJB_INVOCATION_HANDLER_FIELD))
                .make()
                .load(baseClass.getClassLoader(), ClassLoadingStrategy.Default.INJECTION)
                .getLoaded());

        final OJBProxy oJBProxy = proxyClass.getDeclaredConstructor().newInstance();
        //the "handler" is both an IndirectionHandler and InvocationHandler
        proxyClass.getField(OJB_INVOCATION_HANDLER_FIELD).set(oJBProxy, handler);
        return oJBProxy;
    }

    @Override
    public boolean interfaceRequiredForProxyGeneration() {
        return false;
    }
}
