/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.datadictionary;

import org.apache.commons.lang.StringUtils;
import org.kuali.rice.krad.datadictionary.DataDictionaryDefinitionBase;

/**
 * Abstract superclass for all maintainable fields and collections.  Never used directly.
 *
 * @deprecated Use {@link org.kuali.rice.krad.uif.field.Field} subclasses.
 */
@Deprecated
public abstract class MaintainableItemDefinition extends DataDictionaryDefinitionBase {
    private static final long serialVersionUID = 4564613758722159747L;
    
	private String name;

    public MaintainableItemDefinition() {
    }


    /**
     * @return name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets name to the given value.
     * 
     * @param name
     * @throws IllegalArgumentException if the given name is blank
     */
    public void setName(String name) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("invalid (blank) name");
        }
        this.name = name;
    }


    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        return "MaintainableItemDefinition for item " + getName();
    }
}
