/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.maintenance;

import org.kuali.rice.kns.document.authorization.MaintenanceDocumentRestrictions;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.lookup.SelectiveReferenceRefresher;

import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Defines basic methods that all maintainable objects must provide
 *
 * @deprecated Use {@link org.kuali.rice.krad.maintenance.Maintainable}.
 */
@Deprecated
public interface Maintainable extends org.kuali.rice.krad.maintenance.Maintainable, SelectiveReferenceRefresher {

    String getDocumentTitle(MaintenanceDocument document);

    /**
     * Returns instance of the business object that is being maintained.
     */
    @Deprecated
    PersistableBusinessObject getBusinessObject();

    /**
     * Called from a lookup return by the maintenance action.
     */
    @Deprecated
    void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document);

    /**
     * Sets an instance of a business object to be maintained.
     */
    @Deprecated
    void setBusinessObject(PersistableBusinessObject object);

    @Deprecated
    Class getBoClass();

    @Deprecated
    void setBoClass(Class boClass);

    /**
     * This method will cause the Maintainable implementation to save/store the
     * relevant business object(s). This typically is called only after the
     * maint document has gone through state to final.
     */
    @Deprecated
    void saveBusinessObject();

    @Deprecated
    void addMultipleValueLookupResults(MaintenanceDocument document, String collectionName,
            Collection<PersistableBusinessObject> rawValues, boolean needsBlank, PersistableBusinessObject bo);

    @Deprecated
    List<String> getDuplicateIdentifierFieldsFromDataDictionary(String docTypeName, String collectionName);

    @Deprecated
    List<String> getMultiValueIdentifierList(Collection maintCollection, List<String> duplicateIdentifierFields);

    @Deprecated
    boolean hasBusinessObjectExisted(BusinessObject bo, List<String> existingIdentifierList,
            List<String> duplicateIdentifierFields);

    /**
     * Blanks out or sets the default of any value specified as restricted
     * within the {@link MaintenanceDocumentRestrictions} instance.
     *
     * This method should only be called if this maintainable represents the new
     * maintainable of the maintenance document.
     *
     */
    @Deprecated
    void clearBusinessObjectOfRestrictedValues(MaintenanceDocumentRestrictions maintenanceDocumentRestrictions);

    boolean isBoNotesEnabled();

    PersistableBusinessObject retrieveObjectForEditOrCopy(MaintenanceDocument document, Map<String, String> businessObjectKeys);

    /**
     * Gives chance to a maintainable object to prepare and return a
     * maintainable object which might be external to the system
     *
     */
    @Deprecated
    void prepareBusinessObject(BusinessObject businessObject);

    // 3070
    @Deprecated
    void deleteBusinessObject();

    @Deprecated
    boolean isOldBusinessObjectInDocument();

    /**
     * Indicates whether inactive records for the given collection should be
     * display.
     *
     * @param collectionName - name of the collection (or sub-collection) to check inactive
     * record display setting
     * @return true if inactive records should be displayed, false otherwise
     */
    @Deprecated
    boolean getShowInactiveRecords(String collectionName);

    /**
     * Returns the Map used to control the state of inactive record collection
     * display. Exposed for setting from the maintenance jsp.
     */
    @Deprecated
    Map<String, Boolean> getInactiveRecordDisplay();

    /**
     * Indicates to maintainble whether or not inactive records should be
     * displayed for the given collection name.
     *
     * @param collectionName - name of the collection (or sub-collection) to set inactive
     * record display setting
     * @param showInactive - true to display inactive, false to not display inactive
     * records
     */
    @Deprecated
    void setShowInactiveRecords(String collectionName, boolean showInactive);

    /**
     * Populates the new collection lines based on key/value pairs.
     *
     */
    @Deprecated
    Map<String, String> populateNewCollectionLines(Map<String, String> fieldValues,
            MaintenanceDocument maintenanceDocument, String methodToCall);

    /**
     * Gets the holder for the "add line" for a collection on the business
     * object
     *
     */
    @Deprecated
    PersistableBusinessObject getNewCollectionLine(String collectionName);

    /**
     * Adds the new line for the given collection to the business object's
     * collection.
     *
     */
    @Deprecated
    void addNewLineToCollection(String collectionName);

    /**
     * KULRICE-4264 - a hook to change the state of the business object, which
     * is the "new line" of a collection, before it is validated
     *
     */
    @Deprecated
    void processBeforeAddLine(String colName, Class colClass, BusinessObject addBO);

    /**
     * Set default values.
     *
     */
    @Deprecated
    void setGenerateDefaultValues(String docTypeName);

    /**
     * Set default values for blank required fields.
     *
     */
    @Deprecated
    void setGenerateBlankRequiredValues(String docTypeName);

    /**
     * Returns a list of Section objects that specify how to render the view for
     * the maintenance object.
     *
     * @param oldMaintainable - If this is the new maintainable, the old is passed in for
     * reference. If it is the old maintainable, then null will be
     * passed in
     */
    @Deprecated
    List getSections(MaintenanceDocument maintenanceDocument, Maintainable oldMaintainable);

    /**
     * This method populates the business object based on key/value pairs.
     *
     */
    @Deprecated
    Map populateBusinessObject(Map<String, String> fieldValues, MaintenanceDocument maintenanceDocument,
            String methodToCall);

    /**
     * Returns a string that will be displayed as title on the maintenance
     * screen.
     */
    @Deprecated
    String getMaintainableTitle();

    void setupNewFromExisting(MaintenanceDocument document,
            Map<String, String[]> parameters);

    void processAfterCopy(MaintenanceDocument document,
            Map<String, String[]> requestParameters);

    void processAfterEdit(MaintenanceDocument document,
            Map<String, String[]> requestParameters);

    void processAfterNew(MaintenanceDocument document,
            Map<String, String[]> requestParameters);

    void processAfterPost(MaintenanceDocument document,
            Map<String, String[]> requestParameters);
}
