/*-
 * #%L
 * %%
 * Copyright (C) 2005 - 2024 Kuali, Inc. - All Rights Reserved
 * %%
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 * 
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 * #L%
 */

package org.kuali.rice.kns.rule;

import org.apache.struts.action.ActionForm;
import org.kuali.rice.kns.rule.event.PromptBeforeValidationEvent;
import org.kuali.rice.krad.rules.rule.BusinessRule;

import javax.servlet.http.HttpServletRequest;

/**
 * An interface for a class that provides the ability to prompt the user with a question prior to running a document action.
 * An implementation class of this interface may be specified in the document data dictionary file.
 * 
 * By default, unless KualiDocumentActionBase is overridden, the sole method will be invoked upon using the "approve", "blanketApprove",
 * "performRouteReport", and "route" methodToCalls.
 *
 * @deprecated Only used in KNS classes, use KRAD.
 */
@Deprecated
public interface PromptBeforeValidation extends BusinessRule {

    /**
     * Callback method from Maintenance action that allows checks to be done and response redirected via the PreRulesCheckEvent
     * 
     * @param form
     * @param request
     * @param event stores various information necessary to render the question prompt
     * @return boolean indicating whether the validation (and if validation successful, the action) should continue.  If false, the
     * values within the event parameter will determine how the struts action handler should proceed
     */
    public boolean processPrompts(ActionForm form, HttpServletRequest request, PromptBeforeValidationEvent event);
}
